/// <reference path="./internal_*.d.ts" />
declare namespace net.fabricmc.fabric.mixin.screen {
    interface ScreenAccessor {
        abstract getTextRenderer(): net.minecraft.client.gui.Font;
        abstract getClient(): Internal.Minecraft;
        get textRenderer(): net.minecraft.client.gui.Font
        get client(): Internal.Minecraft
    }
    type ScreenAccessor_ = ScreenAccessor;
}
declare namespace Internal {
    interface ChatDecorator {
        abstract decorate(arg0: Internal.ServerPlayer_, arg1: net.minecraft.network.chat.Component_): Internal.CompletableFuture<net.minecraft.network.chat.Component>;
        (arg0: Internal.ServerPlayer, arg1: net.minecraft.network.chat.Component): Internal.CompletableFuture_<net.minecraft.network.chat.Component>;
        readonly PLAIN: Internal.ChatDecorator;
    }
    type ChatDecorator_ = ChatDecorator;
    interface SoundInstanceMixin extends Internal.FabricSoundInstance {
        getAudioStream(loader: Internal.SoundBufferLibrary_, id: ResourceLocation_, repeatInstantly: boolean): Internal.CompletableFuture<Internal.AudioStream>;
    }
    type SoundInstanceMixin_ = SoundInstanceMixin;
    class MeteoritePlacerItem extends Internal.AEBaseItem implements Internal.AEToolItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MeteoritePlacerItem_ = MeteoritePlacerItem;
    class AdvancementJS {
        constructor(a: Internal.Advancement_)
        addChild(a: Internal.AdvancementJS_): void;
        getId(): ResourceLocation;
        getDisplayText(): net.minecraft.network.chat.Component;
        getTitle(): net.minecraft.network.chat.Component;
        id(): ResourceLocation;
        getParent(): this;
        hasDisplay(): boolean;
        getDescription(): net.minecraft.network.chat.Component;
        getChildren(): Internal.Set<Internal.AdvancementJS>;
        get id(): ResourceLocation
        get displayText(): net.minecraft.network.chat.Component
        get title(): net.minecraft.network.chat.Component
        get parent(): Internal.AdvancementJS
        get description(): net.minecraft.network.chat.Component
        get children(): Internal.Set<Internal.AdvancementJS>
        readonly advancement: Internal.Advancement;
    }
    type AdvancementJS_ = AdvancementJS;
    class RopeAndNailItem extends Internal.BaseComfortsItem {
        constructor(block: Internal.Block_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RopeAndNailItem_ = RopeAndNailItem;
    class FocalLinkBlock extends Internal.BaseEntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(world: Internal.Level_, state: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getColor(world: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type FocalLinkBlock_ = FocalLinkBlock;
    class NoteblockEffect implements Internal.PrestidigitationEffect {
        constructor()
        effectEntity(env: Internal.CastingEnvironment_, entity: Internal.Entity_): void;
        effectBlock(env: Internal.CastingEnvironment_, position: BlockPos_): void;
    }
    type NoteblockEffect_ = NoteblockEffect;
    class ModItems$1 extends Internal.ItemNameBlockItem {
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ModItems$1_ = ModItems$1;
    class CRBogeyBlockEntity extends Internal.AbstractBogeyBlockEntity implements Internal.IHaveGoggleInformation {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
    }
    type CRBogeyBlockEntity_ = CRBogeyBlockEntity;
    interface TextureSheetParticleAccessor {
        abstract porting_lib$setSprite(arg0: Internal.TextureAtlasSprite_): void;
        (arg0: Internal.TextureAtlasSprite): void;
    }
    type TextureSheetParticleAccessor_ = TextureSheetParticleAccessor;
    class SignBlockEntity extends Internal.BlockEntity implements Internal.IMixinSignBlockEntity, Internal.AccessorSignBlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        constructor($$0: Internal.BlockEntityType_<any>, $$1: BlockPos_, $$2: Internal.BlockState_)
        setText($$0: Internal.SignText_, $$1: boolean): boolean;
        updateText($$0: Internal.UnaryOperator_<Internal.SignText>, $$1: boolean): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getMaxTextLineWidth(): number;
        getPlayerWhoMayEdit(): Internal.UUID;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setWaxed($$0: boolean): boolean;
        playerIsTooFarAwayToEdit($$0: Internal.UUID_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getUpdatePacket(): Internal.Packet<any>;
        onLoad(): void;
        updateSignText($$0: Internal.Player_, $$1: boolean, $$2: Internal.List_<Internal.FilteredText>): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        bookshelf$markUpdated(): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        canExecuteClickCommands($$0: boolean, $$1: Internal.Player_): boolean;
        litematica_getFrontText(): Internal.SignText;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        getTextFacingPlayer($$0: Internal.Player_): Internal.SignText;
        getFrontText(): Internal.SignText;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isWaxed(): boolean;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        isFacingFrontText($$0: Internal.Player_): boolean;
        getBackText(): Internal.SignText;
        getText($$0: boolean): Internal.SignText;
        litematica_getBackText(): Internal.SignText;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getTextLineHeight(): number;
        static tick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.SignBlockEntity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        executeClickCommandsIfPresent($$0: Internal.Player_, $$1: Internal.Level_, $$2: BlockPos_, $$3: boolean): boolean;
        setAllowedPlayerEditor($$0: Internal.UUID_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get maxTextLineWidth(): number
        get playerWhoMayEdit(): Internal.UUID
        set waxed($$0: boolean)
        get updatePacket(): Internal.Packet<any>
        get frontText(): Internal.SignText
        get waxed(): boolean
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get backText(): Internal.SignText
        get textLineHeight(): number
        set allowedPlayerEditor($$0: Internal.UUID_)
    }
    type SignBlockEntity_ = SignBlockEntity;
    class Hashtable <K, V> extends Internal.Dictionary<K, V> implements Internal.Cloneable, Internal.Map<K, V>, Internal.Serializable {
        constructor(arg0: Internal.Map_<K, V>)
        constructor()
        constructor(arg0: number)
        constructor(arg0: number, arg1: number)
        clone(): any;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        containsValue(arg0: any): boolean;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        keys(): Internal.Enumeration<K>;
        containsKey(arg0: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        contains(arg0: any): boolean;
        elements(): Internal.Enumeration<V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        putIfAbsent(arg0: K, arg1: V): V;
        keySet(): Internal.Set<K>;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        putAll(arg0: Internal.Map_<K, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type Hashtable_<K, V> = Hashtable<K, V>;
    abstract class SimpleRegistryImpl <K, V> implements Internal.SimpleRegistry<K, V> {
        constructor()
        registerProvider(provider: Internal.SimpleRegistry$Provider_<K, V>): void;
        static create<K, V>(): Internal.SimpleRegistry<K, V>;
        static multi<K, V>(): Internal.SimpleRegistry$Multi<K, V>;
        static single<K, V>(): Internal.SimpleRegistry<K, V>;
        abstract get(arg0: K): V;
        get(state: Internal.StateHolder_<K, any>): V;
        register(object: K, value: V): void;
        abstract invalidate(): void;
    }
    type SimpleRegistryImpl_<K, V> = SimpleRegistryImpl<K, V>;
    interface ComponentContents {
        resolve($$0: Internal.CommandSourceStack_, $$1: Internal.Entity_, $$2: number): Internal.MutableComponent;
        visit<T>($$0: Internal.FormattedText$StyledContentConsumer_<T>, $$1: Internal.Style_): Internal.Optional<T>;
        visit<T>($$0: Internal.FormattedText$ContentConsumer_<T>): Internal.Optional<T>;
        readonly EMPTY: Internal.ComponentContents;
    }
    type ComponentContents_ = ComponentContents;
    class VideoMode {
        constructor($$0: any_)
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number)
        constructor($$0: any_)
        static read($$0: string): Internal.Optional<Internal.VideoMode>;
        getRedBits(): number;
        getWidth(): number;
        getBlueBits(): number;
        write(): string;
        getHeight(): number;
        getGreenBits(): number;
        getRefreshRate(): number;
        get redBits(): number
        get width(): number
        get blueBits(): number
        get height(): number
        get greenBits(): number
        get refreshRate(): number
    }
    type VideoMode_ = VideoMode;
    class PickaxeHeaterItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static getModifiedBlockDrops(items: Internal.ObjectArrayList_<Internal.ItemStack>, context: Internal.LootContext_, ores: Internal.TagKey_<Internal.Block>, rawOres: Internal.TagKey_<Internal.Item>): Internal.ObjectArrayList<Internal.ItemStack>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static getRecipeFor(item: Internal.ItemStack_, level: Internal.Level_): Internal.Optional<Internal.AbstractCookingRecipe>;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PickaxeHeaterItem_ = PickaxeHeaterItem;
    class ForgeConfigSpec$Builder {
        constructor()
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<V>, converter: com.electronwill.nightconfig.core.EnumGetMethod_, validator: Internal.Predicate_<any>, clazz: V): Internal.ForgeConfigSpec$EnumValue<V>;
        define(path: string, defaultValue: boolean): Internal.ForgeConfigSpec$BooleanValue;
        defineInRange(path: Internal.List_<string>, defaultValue: number, min: number, max: number): Internal.ForgeConfigSpec$LongValue;
        define<T>(path: Internal.List_<string>, defaultValue: T): Internal.ForgeConfigSpec$ConfigValue<T>;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultValue: V, validator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$EnumValue<V>;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultValue: V): Internal.ForgeConfigSpec$EnumValue<V>;
        defineInRange(path: string, defaultValue: number, min: number, max: number): Internal.ForgeConfigSpec$DoubleValue;
        defineInRange(path: string, defaultValue: number, min: number, max: number): Internal.ForgeConfigSpec$IntValue;
        defineList<T>(path: string, defaultSupplier: Internal.Supplier_<Internal.List<T>>, elementValidator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<Internal.List<T>>;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultValue: V, converter: com.electronwill.nightconfig.core.EnumGetMethod_, validator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$EnumValue<V>;
        pop(): this;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultValue: V, ...acceptableValues: V[]): Internal.ForgeConfigSpec$EnumValue<V>;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultValue: V, converter: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.ForgeConfigSpec$EnumValue<V>;
        defineInList<T>(path: string, defaultSupplier: Internal.Supplier_<T>, acceptableValues: Internal.Collection_<T>): Internal.ForgeConfigSpec$ConfigValue<T>;
        comment(...comment: string[]): this;
        defineInList<T>(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<T>, acceptableValues: Internal.Collection_<T>): Internal.ForgeConfigSpec$ConfigValue<T>;
        define(path: string, defaultSupplier: Internal.Supplier_<boolean>): Internal.ForgeConfigSpec$BooleanValue;
        defineInList<T>(path: string, defaultValue: T, acceptableValues: Internal.Collection_<T>): Internal.ForgeConfigSpec$ConfigValue<T>;
        defineInRange(path: string, defaultSupplier: Internal.Supplier_<number>, min: number, max: number): Internal.ForgeConfigSpec$DoubleValue;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultValue: V, validator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$EnumValue<V>;
        defineInRange<V extends Internal.Comparable<any>>(path: string, defaultSupplier: Internal.Supplier_<V>, min: V, max: V, clazz: V): Internal.ForgeConfigSpec$ConfigValue<V>;
        define<T>(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<T>, validator: Internal.Predicate_<any>, clazz: typeof any): Internal.ForgeConfigSpec$ConfigValue<T>;
        defineList<T>(path: Internal.List_<string>, defaultValue: Internal.List_<T>, elementValidator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<Internal.List<T>>;
        defineInRange(path: Internal.List_<string>, defaultValue: number, min: number, max: number): Internal.ForgeConfigSpec$DoubleValue;
        define<T>(path: Internal.List_<string>, defaultValue: T, validator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<T>;
        translation(translationKey: string): this;
        define(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<boolean>): Internal.ForgeConfigSpec$BooleanValue;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<V>, validator: Internal.Predicate_<any>, clazz: V): Internal.ForgeConfigSpec$EnumValue<V>;
        defineInRange<V extends Internal.Comparable<any>>(path: string, defaultValue: V, min: V, max: V, clazz: V): Internal.ForgeConfigSpec$ConfigValue<V>;
        define(path: Internal.List_<string>, defaultValue: boolean): Internal.ForgeConfigSpec$BooleanValue;
        defineInRange(path: Internal.List_<string>, defaultValue: number, min: number, max: number): Internal.ForgeConfigSpec$IntValue;
        defineInRange(path: string, defaultSupplier: Internal.Supplier_<number>, min: number, max: number): Internal.ForgeConfigSpec$LongValue;
        defineInRange(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<number>, min: number, max: number): Internal.ForgeConfigSpec$DoubleValue;
        defineInRange<V extends Internal.Comparable<any>>(path: Internal.List_<string>, defaultValue: V, min: V, max: V, clazz: V): Internal.ForgeConfigSpec$ConfigValue<V>;
        defineInRange<V extends Internal.Comparable<any>>(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<V>, min: V, max: V, clazz: V): Internal.ForgeConfigSpec$ConfigValue<V>;
        define<T>(path: string, defaultValue: T, validator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<T>;
        defineInList<T>(path: Internal.List_<string>, defaultValue: T, acceptableValues: Internal.Collection_<T>): Internal.ForgeConfigSpec$ConfigValue<T>;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultValue: V, converter: com.electronwill.nightconfig.core.EnumGetMethod_, ...acceptableValues: V[]): Internal.ForgeConfigSpec$EnumValue<V>;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultValue: V, ...acceptableValues: V[]): Internal.ForgeConfigSpec$EnumValue<V>;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultValue: V, acceptableValues: Internal.Collection_<V>): Internal.ForgeConfigSpec$EnumValue<V>;
        defineInRange(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<number>, min: number, max: number): Internal.ForgeConfigSpec$IntValue;
        worldRestart(): this;
        define<T>(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<T>, validator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<T>;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultValue: V, converter: com.electronwill.nightconfig.core.EnumGetMethod_, acceptableValues: Internal.Collection_<V>): Internal.ForgeConfigSpec$EnumValue<V>;
        pop(count: number): this;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultValue: V, converter: com.electronwill.nightconfig.core.EnumGetMethod_, acceptableValues: Internal.Collection_<V>): Internal.ForgeConfigSpec$EnumValue<V>;
        comment(comment: string): this;
        defineList<T>(path: string, defaultValue: Internal.List_<T>, elementValidator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<Internal.List<T>>;
        defineInRange(path: string, defaultSupplier: Internal.Supplier_<number>, min: number, max: number): Internal.ForgeConfigSpec$IntValue;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultSupplier: Internal.Supplier_<V>, validator: Internal.Predicate_<any>, clazz: V): Internal.ForgeConfigSpec$EnumValue<V>;
        define<T>(path: Internal.List_<string>, value: Internal.ForgeConfigSpec$ValueSpec_, defaultSupplier: Internal.Supplier_<T>): Internal.ForgeConfigSpec$ConfigValue<T>;
        build(): Internal.ForgeConfigSpec;
        defineListAllowEmpty<T>(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<Internal.List<T>>, elementValidator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<Internal.List<T>>;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultValue: V): Internal.ForgeConfigSpec$EnumValue<V>;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultSupplier: Internal.Supplier_<V>, converter: com.electronwill.nightconfig.core.EnumGetMethod_, validator: Internal.Predicate_<any>, clazz: V): Internal.ForgeConfigSpec$EnumValue<V>;
        define<T>(path: string, defaultValue: T): Internal.ForgeConfigSpec$ConfigValue<T>;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultValue: V, converter: com.electronwill.nightconfig.core.EnumGetMethod_, ...acceptableValues: V[]): Internal.ForgeConfigSpec$EnumValue<V>;
        defineEnum<V extends Internal.Enum<V>>(path: string, defaultValue: V, converter: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.ForgeConfigSpec$EnumValue<V>;
        defineInRange(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<number>, min: number, max: number): Internal.ForgeConfigSpec$LongValue;
        defineInRange(path: string, defaultValue: number, min: number, max: number): Internal.ForgeConfigSpec$LongValue;
        define<T>(path: string, defaultSupplier: Internal.Supplier_<T>, validator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<T>;
        defineList<T>(path: Internal.List_<string>, defaultSupplier: Internal.Supplier_<Internal.List<T>>, elementValidator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$ConfigValue<Internal.List<T>>;
        push(path: Internal.List_<string>): this;
        configure<T>(consumer: Internal.Function_<Internal.ForgeConfigSpec$Builder, T>): org.apache.commons.lang3.tuple.Pair<T, Internal.ForgeConfigSpec>;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultValue: V, converter: com.electronwill.nightconfig.core.EnumGetMethod_, validator: Internal.Predicate_<any>): Internal.ForgeConfigSpec$EnumValue<V>;
        push(path: string): this;
        defineEnum<V extends Internal.Enum<V>>(path: Internal.List_<string>, defaultValue: V, acceptableValues: Internal.Collection_<V>): Internal.ForgeConfigSpec$EnumValue<V>;
    }
    type ForgeConfigSpec$Builder_ = ForgeConfigSpec$Builder;
    interface MenuBuilder$ScreenFactory <M extends Internal.AbstractContainerMenu, T extends Internal.Screen & Internal.MenuAccess<M>> {
        abstract create(arg0: M, arg1: Internal.Inventory_, arg2: net.minecraft.network.chat.Component_): T;
        (arg0: M, arg1: Internal.Inventory, arg2: net.minecraft.network.chat.Component): T;
    }
    type MenuBuilder$ScreenFactory_<M extends Internal.AbstractContainerMenu, T extends Internal.Screen & Internal.MenuAccess<M>> = MenuBuilder$ScreenFactory<M, T>;
    class RedstoneLinkNetworkHandler$Frequency {
        getStack(): Internal.ItemStack;
        static of(stack: Internal.ItemStack_): Internal.RedstoneLinkNetworkHandler$Frequency;
        get stack(): Internal.ItemStack
        static readonly EMPTY: Internal.RedstoneLinkNetworkHandler$Frequency;
    }
    type RedstoneLinkNetworkHandler$Frequency_ = RedstoneLinkNetworkHandler$Frequency;
    class TravellingPoint$SteerDirection extends Internal.Enum<Internal.TravellingPoint$SteerDirection> {
        static values(): Internal.TravellingPoint$SteerDirection[];
        static valueOf(name: string): Internal.TravellingPoint$SteerDirection;
        static readonly NONE: Internal.TravellingPoint$SteerDirection;
        static readonly LEFT: Internal.TravellingPoint$SteerDirection;
        static readonly RIGHT: Internal.TravellingPoint$SteerDirection;
    }
    type TravellingPoint$SteerDirection_ = TravellingPoint$SteerDirection | "right" | "none" | "left";
    class CloudStatus extends Internal.Enum<Internal.CloudStatus> implements Internal.OptionEnum {
        getKey(): string;
        static valueOf($$0: string): Internal.CloudStatus;
        static values(): Internal.CloudStatus[];
        getCaption(): net.minecraft.network.chat.Component;
        getId(): number;
        get key(): string
        get caption(): net.minecraft.network.chat.Component
        get id(): number
        static readonly OFF: Internal.CloudStatus;
        static readonly FAST: Internal.CloudStatus;
        static readonly FANCY: Internal.CloudStatus;
    }
    type CloudStatus_ = "off" | "fancy" | CloudStatus | "fast";
    class Ease extends Internal.Enum<Internal.Ease> {
        static getEase(b: number): Internal.Ease;
        static valueOf(name: string): Internal.Ease;
        getId(): number;
        invoke(f: number): number;
        static values(): Internal.Ease[];
        get id(): number
        static readonly INCUBIC: Internal.Ease;
        static readonly INOUTELASTIC: Internal.Ease;
        static readonly INOUTEXPO: Internal.Ease;
        static readonly INQUINT: Internal.Ease;
        static readonly OUTQUART: Internal.Ease;
        static readonly OUTCIRC: Internal.Ease;
        static readonly INOUTQUART: Internal.Ease;
        static readonly INOUTQUINT: Internal.Ease;
        static readonly INBACK: Internal.Ease;
        static readonly INQUAD: Internal.Ease;
        static readonly OUTELASTIC: Internal.Ease;
        static readonly INSINE: Internal.Ease;
        static readonly INOUTCUBIC: Internal.Ease;
        static readonly INELASTIC: Internal.Ease;
        static readonly INOUTBOUNCE: Internal.Ease;
        static readonly INOUTQUAD: Internal.Ease;
        static readonly INEXPO: Internal.Ease;
        static readonly INOUTCIRC: Internal.Ease;
        static readonly INOUTBACK: Internal.Ease;
        static readonly OUTSINE: Internal.Ease;
        static readonly OUTQUAD: Internal.Ease;
        static readonly OUTBOUNCE: Internal.Ease;
        static readonly INQUART: Internal.Ease;
        static readonly OUTEXPO: Internal.Ease;
        static readonly CONSTANT: Internal.Ease;
        static readonly OUTQUINT: Internal.Ease;
        static readonly INCIRC: Internal.Ease;
        static readonly INOUTSINE: Internal.Ease;
        static readonly OUTCUBIC: Internal.Ease;
        static readonly INBOUNCE: Internal.Ease;
        static readonly LINEAR: Internal.Ease;
        static readonly OUTBACK: Internal.Ease;
    }
    type Ease_ = "outelastic" | "linear" | "constant" | "inoutquint" | "inoutback" | "inoutcubic" | "inoutsine" | "inoutexpo" | "inoutquad" | "inoutelastic" | "outback" | "outbounce" | "inelastic" | "inquart" | "inexpo" | "outquad" | "insine" | "outsine" | "inoutquart" | "inback" | "inquint" | "incirc" | Ease | "inquad" | "outexpo" | "incubic" | "inoutbounce" | "outquart" | "outcirc" | "inbounce" | "outquint" | "outcubic" | "inoutcirc";
    class ChestMenuClickHandler extends Internal.Record {
        constructor(type: Internal.ClickType_, button: number, callback: Internal.ChestMenuClickEvent$Callback_, autoHandle: boolean)
        autoHandle(): boolean;
        test(event: Internal.ChestMenuClickEvent_): boolean;
        callback(): Internal.ChestMenuClickEvent$Callback;
        button(): number;
        type(): Internal.ClickType;
    }
    type ChestMenuClickHandler_ = ChestMenuClickHandler;
    class FireworkStarRecipe extends Internal.CustomRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
        static SHAPE_BY_ITEM: {[key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.Item]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.FireChargeItem]: Internal.FireworkRocketItem$Shape, [key: Internal.Item]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.PlayerHeadItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape, [key: Internal.StandingAndWallBlockItem]: Internal.FireworkRocketItem$Shape};
        static SHAPE_INGREDIENT: Internal.Ingredient;
    }
    type FireworkStarRecipe_ = FireworkStarRecipe;
    class BasicStorageCell extends Internal.AEBaseItem implements Internal.IBasicCellItem, Internal.AEToolItem {
        constructor(properties: Internal.Item$Properties_, coreItem: Internal.ItemLike_, housingItem: Internal.ItemLike_, idleDrain: number, kilobytes: number, bytesPerType: number, totalTypes: number, keyType: Internal.AEKeyType_)
        getIdleDrain(): number;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        setDigSpeed(speed: number): void;
        setAttackSpeed(attackSpeed: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        setFuzzyMode(is: Internal.ItemStack_, fzMode: Internal.FuzzyMode_): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getBytes(cellItem: Internal.ItemStack_): number;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getConfigInventory(is: Internal.ItemStack_): Internal.ConfigInventory;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getTotalTypes(cellItem: Internal.ItemStack_): number;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        getKeyType(): Internal.AEKeyType;
        addCellInformationToTooltip(is: Internal.ItemStack_, lines: Internal.List_<net.minecraft.network.chat.Component>): void;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        static getColor(stack: Internal.ItemStack_, tintIndex: number): number;
        getBytesPerType(cellItem: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCellTooltipImage(is: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isBlackListed(cellItem: Internal.ItemStack_, requestedAddition: Internal.AEKey_): boolean;
        isStorageCell(i: Internal.ItemStack_): boolean;
        getFuzzyMode(is: Internal.ItemStack_): Internal.FuzzyMode;
        getUpgrades(is: Internal.ItemStack_): Internal.IUpgradeInventory;
        emi(amount: number): Internal.EmiStack;
        isEditable(is: Internal.ItemStack_): boolean;
        storableInStorageCell(): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        get idleDrain(): number
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get keyType(): Internal.AEKeyType
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type BasicStorageCell_ = BasicStorageCell;
    interface BeaconBlockEntityLightSource {
        abstract lambdynlights$setDynamicLightBeam(arg0: Internal.BeaconLightBehavior_): void;
        abstract lambdynlights$getDynamicLightBeam(): Internal.BeaconLightBehavior;
        abstract lambdynlights$getLevels(): number;
    }
    type BeaconBlockEntityLightSource_ = BeaconBlockEntityLightSource;
    interface UnbakedModel {
        abstract bake(arg0: Internal.ModelBaker_, arg1: Internal.Function_<Internal.Material, Internal.TextureAtlasSprite>, arg2: Internal.ModelState_, arg3: ResourceLocation_): Internal.BakedModel;
        abstract getDependencies(): Internal.Collection<ResourceLocation>;
        abstract resolveParents(arg0: Internal.Function_<ResourceLocation, Internal.UnbakedModel>): void;
        get dependencies(): Internal.Collection<ResourceLocation>
    }
    type UnbakedModel_ = UnbakedModel;
    interface IMergeableBE {
        abstract accept(arg0: Internal.BlockEntity_): void;
        (arg0: Internal.BlockEntity): void;
    }
    type IMergeableBE_ = IMergeableBE;
    class MoltenCopperFluid extends Internal.MoltenMetalFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenCopperFluid_ = MoltenCopperFluid;
    class Silverfish extends Internal.Monster {
        constructor($$0: Internal.EntityType_<Internal.Silverfish>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        static checkSilverfishSpawnRules($$0: Internal.EntityType_<Internal.Silverfish>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Silverfish_ = Silverfish;
    class SystemReport implements Internal.SystemReportAccessor {
        constructor()
        setDetail($$0: string, $$1: Internal.Supplier_<string>): void;
        static getOPERATING_SYSTEM(): string;
        toLineSeparatedString(): string;
        getEntries(): Internal.Map<any, any>;
        setDetail($$0: string, $$1: string): void;
        static getOPERATING_SYSTEM$create_$md$fca01f$4(): string;
        static getJAVA_VERSION(): string;
        appendToCrashReportString($$0: Internal.StringBuilder_): void;
        static getJAVA_VERSION$create_$md$fca01f$5(): string;
        get OPERATING_SYSTEM(): string
        get entries(): Internal.Map<any, any>
        get OPERATING_SYSTEM$create_$md$fca01f$4(): string
        get JAVA_VERSION(): string
        get JAVA_VERSION$create_$md$fca01f$5(): string
        static readonly BYTES_PER_MEBIBYTE: 1048576;
    }
    type SystemReport_ = SystemReport;
    class AddWorldgenEventJS extends Internal.StartupEventJS {
        constructor()
        addOre(p: Internal.Consumer_<Internal.AddOreProperties>): void;
        addLake(p: Internal.Consumer_<Internal.AddLakeProperties>): void;
        addSpawn(filter: Internal.BiomeFilter_, category: Internal.MobCategory_, spawn: string): void;
        addSpawn(category: Internal.MobCategory_, spawn: string): void;
        addSpawn(p: Internal.Consumer_<Internal.AddSpawnProperties>): void;
        readonly anchors: typeof Internal.VerticalAnchor;
    }
    type AddWorldgenEventJS_ = AddWorldgenEventJS;
    class HugeGlowshroomFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type HugeGlowshroomFeature_ = HugeGlowshroomFeature;
    class AllFanProcessingTypes$SmokingType implements Internal.FanProcessingType {
        constructor()
        canProcess(stack: Internal.ItemStack_, level: Internal.Level_): boolean;
        getPriority(): number;
        morphAirFlow(particleAccess: Internal.FanProcessingType$AirFlowParticleAccess_, random: Internal.RandomSource_): void;
        isValidAt(level: Internal.Level_, pos: BlockPos_): boolean;
        static getAt(level: Internal.Level_, pos: BlockPos_): Internal.FanProcessingType;
        process(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemStack>;
        static parse(str: string): Internal.FanProcessingType;
        affectEntity(entity: Internal.Entity_, level: Internal.Level_): void;
        spawnProcessingParticles(level: Internal.Level_, pos: Vec3d_): void;
        get priority(): number
    }
    type AllFanProcessingTypes$SmokingType_ = AllFanProcessingTypes$SmokingType;
    interface Object2BooleanMap <K> extends Internal.Object2BooleanFunction<K>, Internal.Map<K, boolean> {
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2BooleanFunction;
        test(arg0: K): boolean;
        and(arg0: Internal.Predicate_<K>): Internal.Predicate<K>;
        /**
         * @deprecated
        */
        containsValue(arg0: any): boolean;
        computeIfAbsent(arg0: K, arg1: Internal.Predicate_<K>): boolean;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2BooleanFunction<T>;
        replaceAll(arg0: Internal.BiFunction_<K, boolean, boolean>): void;
        keySet(): Internal.Set<any>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        removeBoolean(arg0: any): boolean;
        putIfAbsent(arg0: K, arg1: boolean): boolean;
        replace(arg0: K, arg1: boolean): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        computeBoolean(arg0: K, arg1: Internal.BiFunction_<K, boolean, boolean>): boolean;
        andThenByte(arg0: Internal.Boolean2ByteFunction_): Internal.Object2ByteFunction<K>;
        andThenLong(arg0: Internal.Boolean2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        entrySet(): Internal.Set<any>;
        or(arg0: Internal.Predicate_<K>): Internal.Predicate<K>;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: boolean): boolean;
        merge(arg0: K, arg1: boolean, arg2: Internal.BiFunction_<boolean, boolean, boolean>): boolean;
        abstract values(): Internal.BooleanCollection;
        put(arg0: K, arg1: boolean): boolean;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: boolean, arg2: boolean): boolean;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2BooleanFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<boolean, T>): Internal.Function<K, T>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        replace(arg0: K, arg1: boolean, arg2: boolean): boolean;
        andThenDouble(arg0: Internal.Boolean2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        remove(arg0: any, arg1: boolean): boolean;
        abstract putAll(arg0: Internal.Map_<K, boolean>): void;
        abstract object2BooleanEntrySet(): Internal.ObjectSet<Internal.Object2BooleanMap$Entry<K>>;
        identity<T>(): Internal.Function<T, T>;
        forEach(arg0: Internal.BiConsumer_<K, boolean>): void;
        abstract defaultReturnValue(arg0: boolean): void;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2BooleanFunction;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, boolean, boolean>): boolean;
        merge(arg0: K, arg1: boolean, arg2: Internal.BiFunction_<boolean, boolean, boolean>): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        of<K, V>(): Internal.Map<K, V>;
        abstract containsValue(arg0: boolean): boolean;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        andThenReference<T>(arg0: Internal.Boolean2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, boolean>): boolean;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
        andThenInt(arg0: Internal.Boolean2IntFunction_): Internal.Object2IntFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, boolean>;
        /**
         * @deprecated
        */
        computeBooleanIfAbsentPartial(arg0: K, arg1: Internal.Object2BooleanFunction_<K>): boolean;
        abstract containsKey(arg0: any): boolean;
        putIfAbsent(arg0: K, arg1: boolean): boolean;
        andThenChar(arg0: Internal.Boolean2CharFunction_): Internal.Object2CharFunction<K>;
        replace(arg0: K, arg1: boolean): boolean;
        computeBooleanIfPresent(arg0: K, arg1: Internal.BiFunction_<K, boolean, boolean>): boolean;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2BooleanFunction<T>;
        andThenObject<T>(arg0: Internal.Boolean2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        andThenFloat(arg0: Internal.Boolean2FloatFunction_): Internal.Object2FloatFunction<K>;
        apply(arg0: K): boolean;
        abstract defaultReturnValue(): boolean;
        compute(arg0: K, arg1: Internal.BiFunction_<K, boolean, boolean>): boolean;
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2BooleanFunction;
        andThenShort(arg0: Internal.Boolean2ShortFunction_): Internal.Object2ShortFunction<K>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: boolean): boolean;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: boolean): boolean;
        abstract getBoolean(arg0: any): boolean;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2BooleanFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        computeIfAbsent(arg0: K, arg1: Internal.Object2BooleanFunction_<K>): boolean;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2BooleanFunction;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2BooleanFunction;
        abstract size(): number;
        abstract hashCode(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        negate(): Internal.Predicate<K>;
        clear(): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        abstract equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        /**
         * @deprecated
        */
        computeBooleanIfAbsent(arg0: K, arg1: Internal.Predicate_<K>): boolean;
        get empty(): boolean
    }
    type Object2BooleanMap_<K> = Object2BooleanMap<K>;
    class MoltenNecromiumFluid extends Internal.MoltenMetalFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenNecromiumFluid_ = MoltenNecromiumFluid;
    class PoiTypeBuilder extends Internal.BuilderBase<Internal.PoiType> {
        constructor(i: ResourceLocation_)
        blocks(r: Internal.BlockState_[]): this;
        createObject(): any;
        maxTickets(i: number): this;
        block(r: Internal.Block_): this;
        validRange(i: number): this;
    }
    type PoiTypeBuilder_ = PoiTypeBuilder;
    interface CustomShapelessRecipe$Factory <R> {
        abstract create(arg0: ResourceLocation_, arg1: Internal.ShapelessRecipeSpec_): R;
        (arg0: ResourceLocation, arg1: Internal.ShapelessRecipeSpec): R;
    }
    type CustomShapelessRecipe$Factory_<R> = CustomShapelessRecipe$Factory<R>;
    class CraftingUnitBlock extends Internal.AbstractCraftingUnitBlock<any> {
        constructor(type: Internal.ICraftingUnitType_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CraftingUnitBlock_ = CraftingUnitBlock;
    interface IUpgradeWrapperAccessor {
        onBeforeDeconstruct(): void;
        abstract getWrappersThatImplementFromMainStorage<T>(arg0: T): Internal.List<T>;
        abstract clearCache(): void;
        abstract getWrappersThatImplement<T>(arg0: T): Internal.List<T>;
    }
    type IUpgradeWrapperAccessor_ = IUpgradeWrapperAccessor;
    interface JsonDeserializationContext {
        abstract deserialize<T>(arg0: Internal.JsonElement_, arg1: Internal.Type_): T;
        (arg0: Internal.JsonElement, arg1: Internal.Type): T;
    }
    type JsonDeserializationContext_ = JsonDeserializationContext;
    interface IToolContext {
        abstract getMaterials(): Internal.MaterialNBT;
        getDefinitionData(): Internal.ToolDefinitionData;
        getModifierList(): Internal.List<Internal.ModifierEntry>;
        getModifierLevel(modifier: Internal.Modifier_): number;
        abstract getUpgrades(): Internal.ModifierNBT;
        getModifierLevel(modifier: Internal.ModifierId_): number;
        abstract getItem(): Internal.Item;
        abstract getPersistentData(): Internal.IModDataView;
        abstract getVolatileData(): Internal.IModDataView;
        abstract getDefinition(): Internal.ToolDefinition;
        getMaterial(index: number): Internal.MaterialVariant;
        abstract getModifiers(): Internal.ModifierNBT;
        hasTag(tag: Internal.TagKey_<Internal.Item>): boolean;
        get materials(): Internal.MaterialNBT
        get definitionData(): Internal.ToolDefinitionData
        get modifierList(): Internal.List<Internal.ModifierEntry>
        get upgrades(): Internal.ModifierNBT
        get item(): Internal.Item
        get persistentData(): Internal.IModDataView
        get volatileData(): Internal.IModDataView
        get definition(): Internal.ToolDefinition
        get modifiers(): Internal.ModifierNBT
    }
    type IToolContext_ = IToolContext;
    abstract class EmiStack implements Internal.EmiIngredient {
        constructor()
        comparison(comparison: Internal.Comparison_): this;
        abstract getKey(): any;
        hasNbt(): boolean;
        isEqual(stack: Internal.EmiStack_): boolean;
        static of<T>(key: Internal.TagKey_<T>): Internal.EmiIngredient;
        static of(fluid: Internal.FluidVariant_, amount: number): Internal.EmiStack;
        comparison(comparison: Internal.Function_<Internal.Comparison, Internal.Comparison>): this;
        abstract isEmpty(): boolean;
        static of<T>(key: Internal.TagKey_<T>, amount: number): Internal.EmiIngredient;
        static of(stack: Internal.ItemStack_, amount: number): Internal.EmiStack;
        static of(stack: Internal.ItemStack_): Internal.EmiStack;
        getEntryOfType(clazz: typeof any): Internal.EmiStack$Entry<any>;
        getAmount(): number;
        abstract getId(): ResourceLocation;
        getEntry(): Internal.EmiStack$Entry<any>;
        isEqual(stack: Internal.EmiStack_, comparison: Internal.Comparison_): boolean;
        static of(list: Internal.List_<Internal.EmiIngredient>): Internal.EmiIngredient;
        getRemainder(): this;
        static of(item: Internal.ItemLike_, amount: number): Internal.EmiStack;
        static of(item: Internal.ItemVariant_): Internal.EmiStack;
        abstract getTooltipText(): Internal.List<net.minecraft.network.chat.Component>;
        static of(ingredient: Internal.Ingredient_, amount: number): Internal.EmiIngredient;
        static areEqual(a: Internal.EmiIngredient_, b: Internal.EmiIngredient_): boolean;
        static of(item: Internal.ItemLike_, nbt: Internal.CompoundTag_, amount: number): Internal.EmiStack;
        setAmount(arg0: number): Internal.EmiIngredient;
        setChance(arg0: number): Internal.EmiIngredient;
        static of(item: Internal.ItemLike_, nbt: Internal.CompoundTag_): Internal.EmiStack;
        abstract copy(): this;
        abstract getNbt(): Internal.CompoundTag;
        abstract getName(): net.minecraft.network.chat.Component;
        setRemainder(stack: Internal.EmiStack_): this;
        static of(fluid: Internal.Fluid_, nbt: Internal.CompoundTag_, amount: number): Internal.EmiStack;
        getChance(): number;
        static of(fluid: Internal.Fluid_): Internal.EmiStack;
        getAmountText(amount: number): net.minecraft.network.chat.Component;
        static of(ingredient: Internal.Ingredient_): Internal.EmiIngredient;
        static of(fluid: Internal.Fluid_, nbt: Internal.CompoundTag_): Internal.EmiStack;
        static of(item: Internal.ItemLike_): Internal.EmiStack;
        static of(item: Internal.ItemVariant_, amount: number): Internal.EmiStack;
        abstract render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        getTooltip(): Internal.List<Internal.ClientTooltipComponent>;
        static of(fluid: Internal.Fluid_, amount: number): Internal.EmiStack;
        static of(list: Internal.List_<Internal.EmiIngredient>, amount: number): Internal.EmiIngredient;
        render(draw: Internal.GuiGraphics_, x: number, y: number, delta: number): void;
        getEmiStacks(): Internal.List<Internal.EmiStack>;
        getKeyOfType<T>(clazz: T): T;
        static of(fluid: Internal.FluidVariant_): Internal.EmiStack;
        getItemStack(): Internal.ItemStack;
        get key(): any
        get empty(): boolean
        get amount(): number
        get id(): ResourceLocation
        get entry(): Internal.EmiStack$Entry<any>
        get remainder(): Internal.EmiStack
        get tooltipText(): Internal.List<net.minecraft.network.chat.Component>
        set amount(arg0: number)
        set chance(arg0: number)
        get nbt(): Internal.CompoundTag
        get name(): net.minecraft.network.chat.Component
        set remainder(stack: Internal.EmiStack_)
        get chance(): number
        get tooltip(): Internal.List<Internal.ClientTooltipComponent>
        get emiStacks(): Internal.List<Internal.EmiStack>
        get itemStack(): Internal.ItemStack
        static readonly EMPTY: Internal.EmptyEmiStack;
    }
    type EmiStack_ = EmiStack;
    interface MemorySegment {
        abstract reinterpret(arg0: number, arg1: Internal.Arena_, arg2: Internal.Consumer_<Internal.MemorySegment>): this;
        abstract segmentOffset(arg0: Internal.MemorySegment_): number;
        abstract toArray(arg0: Internal.ValueLayout$OfByte_): number[];
        abstract spliterator(arg0: Internal.MemoryLayout_): Internal.Spliterator<Internal.MemorySegment>;
        abstract heapBase(): Internal.Optional<any>;
        setAtIndex(arg0: Internal.AddressLayout_, arg1: number, arg2: Internal.MemorySegment_): void;
        abstract asSlice(arg0: number, arg1: number, arg2: number): this;
        getAtIndex(arg0: Internal.AddressLayout_, arg1: number): this;
        ofBuffer(arg0: Internal.Buffer_): this;
        abstract force(): void;
        ofAddress(arg0: number): this;
        getAtIndex(arg0: Internal.ValueLayout$OfFloat_, arg1: number): number;
        set(arg0: Internal.ValueLayout$OfBoolean_, arg1: number, arg2: boolean): void;
        get(arg0: Internal.ValueLayout$OfInt_, arg1: number): number;
        getAtIndex(arg0: Internal.ValueLayout$OfDouble_, arg1: number): number;
        asSlice(arg0: number, arg1: Internal.MemoryLayout_): this;
        setAtIndex(arg0: Internal.ValueLayout$OfFloat_, arg1: number, arg2: number): void;
        setAtIndex(arg0: Internal.ValueLayout$OfShort_, arg1: number, arg2: number): void;
        abstract asReadOnly(): this;
        ofArray(arg0: number[]): this;
        copy(arg0: Internal.MemorySegment_, arg1: number, arg2: Internal.MemorySegment_, arg3: number, arg4: number): void;
        get(arg0: Internal.ValueLayout$OfLong_, arg1: number): number;
        abstract toArray(arg0: Internal.ValueLayout$OfFloat_): number[];
        get(arg0: Internal.ValueLayout$OfChar_, arg1: number): string;
        mismatch(arg0: Internal.MemorySegment_, arg1: number, arg2: number, arg3: Internal.MemorySegment_, arg4: number, arg5: number): number;
        abstract isMapped(): boolean;
        setAtIndex(arg0: Internal.ValueLayout$OfChar_, arg1: number, arg2: string): void;
        abstract byteSize(): number;
        set(arg0: Internal.ValueLayout$OfByte_, arg1: number, arg2: number): void;
        copy(arg0: Internal.MemorySegment_, arg1: Internal.ValueLayout_, arg2: number, arg3: any, arg4: number, arg5: number): void;
        setAtIndex(arg0: Internal.ValueLayout$OfInt_, arg1: number, arg2: number): void;
        get(arg0: Internal.ValueLayout$OfFloat_, arg1: number): number;
        setUtf8String(arg0: number, arg1: string): void;
        getAtIndex(arg0: Internal.ValueLayout$OfInt_, arg1: number): number;
        getAtIndex(arg0: Internal.ValueLayout$OfShort_, arg1: number): number;
        setAtIndex(arg0: Internal.ValueLayout$OfLong_, arg1: number, arg2: number): void;
        abstract reinterpret(arg0: Internal.Arena_, arg1: Internal.Consumer_<Internal.MemorySegment>): this;
        abstract fill(arg0: number): this;
        abstract isReadOnly(): boolean;
        get(arg0: Internal.ValueLayout$OfDouble_, arg1: number): number;
        getUtf8String(arg0: number): string;
        ofArray(arg0: string[]): this;
        abstract elements(arg0: Internal.MemoryLayout_): Internal.Stream<Internal.MemorySegment>;
        get(arg0: Internal.ValueLayout$OfBoolean_, arg1: number): boolean;
        set(arg0: Internal.AddressLayout_, arg1: number, arg2: Internal.MemorySegment_): void;
        ofArray(arg0: number[]): this;
        ofArray(arg0: number[]): this;
        getAtIndex(arg0: Internal.ValueLayout$OfByte_, arg1: number): number;
        abstract isLoaded(): boolean;
        copy(arg0: Internal.MemorySegment_, arg1: Internal.ValueLayout_, arg2: number, arg3: Internal.MemorySegment_, arg4: Internal.ValueLayout_, arg5: number, arg6: number): void;
        get(arg0: Internal.ValueLayout$OfShort_, arg1: number): number;
        get(arg0: Internal.ValueLayout$OfByte_, arg1: number): number;
        abstract toArray(arg0: Internal.ValueLayout$OfChar_): string[];
        setAtIndex(arg0: Internal.ValueLayout$OfBoolean_, arg1: number, arg2: boolean): void;
        set(arg0: Internal.ValueLayout$OfShort_, arg1: number, arg2: number): void;
        copyFrom(arg0: Internal.MemorySegment_): this;
        abstract asByteBuffer(): Internal.ByteBuffer;
        set(arg0: Internal.ValueLayout$OfInt_, arg1: number, arg2: number): void;
        abstract isAccessibleBy(arg0: Internal.Thread_): boolean;
        abstract unload(): void;
        set(arg0: Internal.ValueLayout$OfFloat_, arg1: number, arg2: number): void;
        abstract toArray(arg0: Internal.ValueLayout$OfShort_): number[];
        abstract asOverlappingSlice(arg0: Internal.MemorySegment_): Internal.Optional<Internal.MemorySegment>;
        abstract load(): void;
        set(arg0: Internal.ValueLayout$OfDouble_, arg1: number, arg2: number): void;
        getAtIndex(arg0: Internal.ValueLayout$OfBoolean_, arg1: number): boolean;
        abstract address(): number;
        ofArray(arg0: number[]): this;
        abstract toArray(arg0: Internal.ValueLayout$OfDouble_): number[];
        set(arg0: Internal.ValueLayout$OfChar_, arg1: number, arg2: string): void;
        abstract isNative(): boolean;
        getAtIndex(arg0: Internal.ValueLayout$OfLong_, arg1: number): number;
        copy(arg0: any, arg1: number, arg2: Internal.MemorySegment_, arg3: Internal.ValueLayout_, arg4: number, arg5: number): void;
        setAtIndex(arg0: Internal.ValueLayout$OfDouble_, arg1: number, arg2: number): void;
        getAtIndex(arg0: Internal.ValueLayout$OfChar_, arg1: number): string;
        abstract scope(): Internal.MemorySegment$Scope;
        setAtIndex(arg0: Internal.ValueLayout$OfByte_, arg1: number, arg2: number): void;
        abstract toArray(arg0: Internal.ValueLayout$OfInt_): number[];
        ofArray(arg0: number[]): this;
        set(arg0: Internal.ValueLayout$OfLong_, arg1: number, arg2: number): void;
        abstract asSlice(arg0: number, arg1: number): this;
        abstract hashCode(): number;
        abstract toArray(arg0: Internal.ValueLayout$OfLong_): number[];
        abstract reinterpret(arg0: number): this;
        get(arg0: Internal.AddressLayout_, arg1: number): this;
        ofArray(arg0: number[]): this;
        abstract equals(arg0: any): boolean;
        abstract asSlice(arg0: number): this;
        mismatch(arg0: Internal.MemorySegment_): number;
        get mapped(): boolean
        get readOnly(): boolean
        get loaded(): boolean
        get "native"(): boolean
        readonly NULL: Internal.NativeMemorySegmentImpl;
    }
    type MemorySegment_ = MemorySegment;
    interface Document extends org.w3c.dom.Node {
        abstract getFirstChild(): org.w3c.dom.Node;
        abstract createElement(arg0: string): Internal.Element;
        abstract getInputEncoding(): string;
        abstract setDocumentURI(arg0: string): void;
        abstract getElementsByTagNameNS(arg0: string, arg1: string): Internal.NodeList;
        abstract createCDATASection(arg0: string): Internal.CDATASection;
        abstract getElementsByTagName(arg0: string): Internal.NodeList;
        abstract cloneNode(arg0: boolean): org.w3c.dom.Node;
        abstract createComment(arg0: string): Internal.Comment;
        abstract createElementNS(arg0: string, arg1: string): Internal.Element;
        abstract getFeature(arg0: string, arg1: string): any;
        abstract isDefaultNamespace(arg0: string): boolean;
        abstract hasAttributes(): boolean;
        abstract getDocumentElement(): Internal.Element;
        abstract createProcessingInstruction(arg0: string, arg1: string): Internal.ProcessingInstruction;
        abstract isEqualNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getLocalName(): string;
        abstract getXmlVersion(): string;
        abstract setPrefix(arg0: string): void;
        abstract setXmlVersion(arg0: string): void;
        abstract getChildNodes(): Internal.NodeList;
        abstract getImplementation(): Internal.DOMImplementation;
        abstract lookupNamespaceURI(arg0: string): string;
        abstract adoptNode(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getElementById(arg0: string): Internal.Element;
        abstract setNodeValue(arg0: string): void;
        abstract setUserData(arg0: string, arg1: any, arg2: Internal.UserDataHandler_): any;
        abstract getBaseURI(): string;
        abstract createDocumentFragment(): Internal.DocumentFragment;
        abstract getStrictErrorChecking(): boolean;
        abstract getUserData(arg0: string): any;
        abstract createAttributeNS(arg0: string, arg1: string): Internal.Attr;
        abstract getXmlEncoding(): string;
        abstract getParentNode(): org.w3c.dom.Node;
        abstract createEntityReference(arg0: string): Internal.EntityReference;
        abstract getPrefix(): string;
        abstract getXmlStandalone(): boolean;
        abstract renameNode(arg0: org.w3c.dom.Node_, arg1: string, arg2: string): org.w3c.dom.Node;
        abstract getLastChild(): org.w3c.dom.Node;
        abstract compareDocumentPosition(arg0: org.w3c.dom.Node_): number;
        abstract normalize(): void;
        abstract getOwnerDocument(): this;
        abstract getDoctype(): Internal.DocumentType;
        abstract hasChildNodes(): boolean;
        abstract setStrictErrorChecking(arg0: boolean): void;
        abstract getNodeName(): string;
        abstract setTextContent(arg0: string): void;
        abstract removeChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNodeValue(): string;
        abstract appendChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNamespaceURI(): string;
        abstract insertBefore(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract importNode(arg0: org.w3c.dom.Node_, arg1: boolean): org.w3c.dom.Node;
        abstract isSupported(arg0: string, arg1: string): boolean;
        abstract getPreviousSibling(): org.w3c.dom.Node;
        abstract createTextNode(arg0: string): Internal.Text;
        abstract getDocumentURI(): string;
        abstract lookupPrefix(arg0: string): string;
        abstract isSameNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getTextContent(): string;
        abstract getAttributes(): Internal.NamedNodeMap;
        abstract getNodeType(): number;
        abstract getNextSibling(): org.w3c.dom.Node;
        abstract getDomConfig(): Internal.DOMConfiguration;
        abstract setXmlStandalone(arg0: boolean): void;
        abstract createAttribute(arg0: string): Internal.Attr;
        abstract normalizeDocument(): void;
        abstract replaceChild(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        get firstChild(): org.w3c.dom.Node
        get inputEncoding(): string
        set documentURI(arg0: string)
        get documentElement(): Internal.Element
        get localName(): string
        get xmlVersion(): string
        set prefix(arg0: string)
        set xmlVersion(arg0: string)
        get childNodes(): Internal.NodeList
        get implementation(): Internal.DOMImplementation
        set nodeValue(arg0: string)
        get baseURI(): string
        get strictErrorChecking(): boolean
        get xmlEncoding(): string
        get parentNode(): org.w3c.dom.Node
        get prefix(): string
        get xmlStandalone(): boolean
        get lastChild(): org.w3c.dom.Node
        get ownerDocument(): Internal.Document
        get doctype(): Internal.DocumentType
        set strictErrorChecking(arg0: boolean)
        get nodeName(): string
        set textContent(arg0: string)
        get nodeValue(): string
        get namespaceURI(): string
        get previousSibling(): org.w3c.dom.Node
        get documentURI(): string
        get textContent(): string
        get attributes(): Internal.NamedNodeMap
        get nodeType(): number
        get nextSibling(): org.w3c.dom.Node
        get domConfig(): Internal.DOMConfiguration
        set xmlStandalone(arg0: boolean)
    }
    type Document_ = Document;
    abstract class AbstractNetworkAddon <H> {
        unregisterChannel(channelName: ResourceLocation_): H;
        handleDisconnect(): void;
        getHandler(channel: ResourceLocation_): H;
        registerChannel(channelName: ResourceLocation_, handler: H): boolean;
        getReceivableChannels(): Internal.Set<ResourceLocation>;
        get receivableChannels(): Internal.Set<ResourceLocation>
    }
    type AbstractNetworkAddon_<H> = AbstractNetworkAddon<H>;
    interface Path extends Internal.Comparable<Internal.Path>, Internal.Iterable<Internal.Path>, Internal.Watchable {
        abstract subpath(arg0: number, arg1: number): this;
        abstract relativize(arg0: Internal.Path_): this;
        toFile(): Internal.File;
        compareTo(arg0: any): number;
        of(arg0: Internal.URI_): this;
        abstract getName(arg0: number): this;
        abstract getFileName(): this;
        resolveSibling(arg0: Internal.Path_): this;
        startsWith(arg0: string): boolean;
        iterator(): Internal.Iterator<Internal.Path>;
        resolveSibling(arg0: string): this;
        forEach(arg0: Internal.Consumer_<Internal.Path>): void;
        abstract toRealPath(...arg0: any_[]): this;
        abstract getFileSystem(): Internal.FileSystem;
        abstract startsWith(arg0: Internal.Path_): boolean;
        endsWith(arg0: string): boolean;
        abstract resolve(arg0: Internal.Path_): this;
        abstract compareTo(arg0: Internal.Path_): number;
        abstract endsWith(arg0: Internal.Path_): boolean;
        resolve(arg0: string): this;
        register(arg0: Internal.WatchService_, ...arg1: Internal.WatchEvent$Kind_<any>[]): Internal.WatchKey;
        abstract getNameCount(): number;
        abstract toString(): string;
        abstract toUri(): Internal.URI;
        abstract toAbsolutePath(): this;
        spliterator(): Internal.Spliterator<Internal.Path>;
        abstract register(arg0: Internal.WatchService_, arg1: Internal.WatchEvent$Kind_<any>[], ...arg2: any_[]): Internal.WatchKey;
        abstract normalize(): this;
        abstract hashCode(): number;
        of(arg0: string, ...arg1: string[]): this;
        abstract getRoot(): this;
        abstract equals(arg0: any): boolean;
        abstract isAbsolute(): boolean;
        abstract getParent(): this;
        get fileName(): Internal.Path
        get fileSystem(): Internal.FileSystem
        get nameCount(): number
        get root(): Internal.Path
        get absolute(): boolean
        get parent(): Internal.Path
    }
    type Path_ = Path;
    class ClientboundPlayerCombatKillPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: net.minecraft.network.chat.Component_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getMessage(): net.minecraft.network.chat.Component;
        write($$0: Internal.FriendlyByteBuf_): void;
        getPlayerId(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get message(): net.minecraft.network.chat.Component
        get playerId(): number
        get skippable(): boolean
    }
    type ClientboundPlayerCombatKillPacket_ = ClientboundPlayerCombatKillPacket;
    class RandomSequences extends Internal.SavedData {
        constructor($$0: number)
        get($$0: ResourceLocation_): Internal.RandomSource;
        static load($$0: number, $$1: Internal.CompoundTag_): Internal.RandomSequences;
    }
    type RandomSequences_ = RandomSequences;
    class MinecartHopper extends Internal.AbstractMinecartContainer implements Internal.Hopper {
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number)
        constructor($$0: Internal.EntityType_<Internal.MinecartHopper>, $$1: Internal.Level_)
        stopOpen($$0: Internal.Player_): void;
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setEnabled($$0: boolean): void;
        addChestVehicleSaveData($$0: Internal.CompoundTag_): void;
        isChestVehicleEmpty(): boolean;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        setChanged(): void;
        isOnScoreboardTeam(teamId: string): boolean;
        isChestVehicleStillValid($$0: Internal.Player_): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getWidth(): number;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        getSuckShape(): Internal.VoxelShape;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        getLevelY(): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        chestVehicleDestroyed($$0: DamageSource_, $$1: Internal.Level_, $$2: Internal.Entity_): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        getMaxSpeedOnRail(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        countItem($$0: Internal.Item_): number;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        getTeamId(): string;
        removeChestVehicleItem($$0: number, $$1: number): Internal.ItemStack;
        getFacing(): Internal.Direction;
        getChestVehicleItem($$0: number): Internal.ItemStack;
        canRiderInteract(): boolean;
        shouldCloseCurrentScreen(): boolean;
        getHeight(): number;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        removeChestVehicleItemNoUpdate($$0: number): Internal.ItemStack;
        countNonEmpty(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        generateLootLithium(): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        playSound(id: Internal.SoundEvent_): void;
        clear(): void;
        method_17357($$0: number, $$1: Internal.Inventory_): Internal.AbstractContainerMenu;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        self(): net.minecraft.world.Container;
        getLevelZ(): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static tryClear($$0: any): void;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getSlots(): number;
        getType(): string;
        interactWithContainerVehicle($$0: Internal.Player_): Internal.InteractionResult;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        sophisticatedInvalidateCaps(): void;
        clearChestVehicleContent(): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        unpackChestVehicleLootTable($$0: Internal.Player_): void;
        getChestVehicleSlot($$0: number): Internal.SlotAccess;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        count(ingredient: Internal.Ingredient_): number;
        setMotionX(x: number): void;
        count(): number;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        setTransferCooldown(currentTime: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        isEnabled(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        serializeNBT(): Internal.Tag;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        suckInItems(): boolean;
        canReceiveTransferCooldown(): boolean;
        setDynamicLightEnabled(enabled: boolean): void;
        getStackInSlot(slot: number): Internal.ItemStack;
        readChestVehicleSaveData($$0: Internal.CompoundTag_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        asContainer(): net.minecraft.world.Container;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getAllItems(): Internal.List<Internal.ItemStack>;
        tell(message: net.minecraft.network.chat.Component_): void;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        setZ(z: number): void;
        setChestVehicleItem($$0: number, $$1: Internal.ItemStack_): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        isMutable(): boolean;
        lithiumOnBlockCacheDeleted(): void;
        find(ingredient: Internal.Ingredient_): number;
        getLevelX(): number;
        runCommand(command: string): number;
        set enabled($$0: boolean)
        get chestVehicleEmpty(): boolean
        get width(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get suckShape(): Internal.VoxelShape
        get levelY(): number
        get displayName(): net.minecraft.network.chat.Component
        get maxSpeedOnRail(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        get facing(): Internal.Direction
        get height(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get frame(): boolean
        get levelZ(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get slots(): number
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get maxStackSize(): number
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get enabled(): boolean
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set dynamicLightEnabled(enabled: boolean)
        get motionZ(): number
        get allItems(): Internal.List<Internal.ItemStack>
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        get mutable(): boolean
        get levelX(): number
    }
    type MinecartHopper_ = MinecartHopper;
    interface TemporalField {
        abstract range(): Internal.ValueRange;
        abstract isTimeBased(): boolean;
        abstract toString(): string;
        abstract rangeRefinedBy(arg0: Internal.TemporalAccessor_): Internal.ValueRange;
        abstract isSupportedBy(arg0: Internal.TemporalAccessor_): boolean;
        getDisplayName(arg0: Internal.Locale_): string;
        abstract isDateBased(): boolean;
        resolve(arg0: Internal.Map_<Internal.TemporalField, number>, arg1: Internal.TemporalAccessor_, arg2: Internal.ResolverStyle_): Internal.TemporalAccessor;
        abstract adjustInto<R extends Internal.Temporal>(arg0: R, arg1: number): R;
        abstract getBaseUnit(): Internal.TemporalUnit;
        abstract getRangeUnit(): Internal.TemporalUnit;
        abstract getFrom(arg0: Internal.TemporalAccessor_): number;
        get timeBased(): boolean
        get dateBased(): boolean
        get baseUnit(): Internal.TemporalUnit
        get rangeUnit(): Internal.TemporalUnit
    }
    type TemporalField_ = TemporalField;
    interface SoundInstance extends Internal.SoundInstanceMixin, Internal.FabricSoundInstance {
        getAudioStream(loader: Internal.SoundBufferLibrary_, id: ResourceLocation_, repeatInstantly: boolean): Internal.CompletableFuture<Internal.AudioStream>;
        abstract getAttenuation(): Internal.SoundInstance$Attenuation;
        abstract getLocation(): ResourceLocation;
        abstract getSource(): Internal.SoundSource;
        canStartSilent(): boolean;
        abstract resolve(arg0: Internal.SoundManager_): Internal.WeighedSoundEvents;
        canPlaySound(): boolean;
        abstract getDelay(): number;
        abstract getX(): number;
        abstract getY(): number;
        abstract isLooping(): boolean;
        abstract getVolume(): number;
        abstract getZ(): number;
        abstract getPitch(): number;
        abstract getSound(): Internal.Sound;
        abstract isRelative(): boolean;
        createUnseededRandom(): Internal.RandomSource;
        get attenuation(): Internal.SoundInstance$Attenuation
        get location(): ResourceLocation
        get source(): Internal.SoundSource
        get delay(): number
        get x(): number
        get y(): number
        get looping(): boolean
        get volume(): number
        get z(): number
        get pitch(): number
        get sound(): Internal.Sound
        get relative(): boolean
    }
    type SoundInstance_ = SoundInstance;
    class EntityArgument$Info implements Internal.ArgumentTypeInfo<Internal.EntityArgument, Internal.EntityArgument$Info$Template> {
        constructor()
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        deserializeFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.EntityArgument$Info$Template;
        unpack($$0: Internal.EntityArgument_): Internal.EntityArgument$Info$Template;
        serializeToJson($$0: Internal.EntityArgument$Info$Template_, $$1: Internal.JsonObject_): void;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        serializeToNetwork($$0: Internal.EntityArgument$Info$Template_, $$1: Internal.FriendlyByteBuf_): void;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type EntityArgument$Info_ = EntityArgument$Info;
    class RedstonePowerDisplaySource extends Internal.PercentOrProgressBarDisplaySource {
        constructor()
    }
    type RedstonePowerDisplaySource_ = RedstonePowerDisplaySource;
    class Keyframe <T extends Internal.IValue> extends Internal.Record {
        constructor(length: number, startValue: T, endValue: T)
        constructor(length: number, startValue: T, endValue: T, easingType: Internal.EasingType_, easingArgs: Internal.List_<T>)
        constructor(length: number, startValue: T, endValue: T, easingType: Internal.EasingType_)
        length(): number;
        easingType(): Internal.EasingType;
        endValue(): T;
        startValue(): T;
        easingArgs(): Internal.List<T>;
    }
    type Keyframe_<T extends Internal.IValue> = Keyframe<T>;
    interface ArgumentSignatures$Signer {
        abstract sign(arg0: string): Internal.MessageSignature;
        (arg0: string): Internal.MessageSignature_;
    }
    type ArgumentSignatures$Signer_ = ArgumentSignatures$Signer;
    interface ToDoubleFunction <T> {
        abstract applyAsDouble(arg0: T): number;
        (arg0: T): number;
    }
    type ToDoubleFunction_<T> = ToDoubleFunction<T>;
    interface MapDecorationType <D extends Internal.CustomMapDecoration, M extends Internal.MapBlockMarker<D>> {
        abstract loadDecorationFromBuffer(arg0: Internal.FriendlyByteBuf_): D;
        abstract isFromWorld(): boolean;
        abstract createEmptyMarker(): M;
        abstract loadMarkerFromNBT(arg0: Internal.CompoundTag_): M;
        getAssociatedStructure(): Internal.Optional<Internal.HolderSet<Internal.Structure>>;
        abstract getWorldMarkerFromWorld(arg0: Internal.BlockGetter_, arg1: BlockPos_): M;
        getCustomFactoryID(): ResourceLocation;
        getDefaultMapColor(): number;
        get fromWorld(): boolean
        get associatedStructure(): Internal.Optional<Internal.HolderSet<Internal.Structure>>
        get customFactoryID(): ResourceLocation
        get defaultMapColor(): number
    }
    type MapDecorationType_<D extends Internal.CustomMapDecoration, M extends Internal.MapBlockMarker<D>> = MapDecorationType<D, M>;
    class IMeltingContainer$OreRateType extends Internal.Enum<Internal.IMeltingContainer$OreRateType> {
        static parse(parent: Internal.JsonObject_, key: string): Internal.IMeltingContainer$OreRateType;
        getName(): string;
        static values(): Internal.IMeltingContainer$OreRateType[];
        static valueOf(name: string): Internal.IMeltingContainer$OreRateType;
        get name(): string
        static readonly GEM: Internal.IMeltingContainer$OreRateType;
        static readonly METAL: Internal.IMeltingContainer$OreRateType;
    }
    type IMeltingContainer$OreRateType_ = "metal" | IMeltingContainer$OreRateType | "gem";
    class PistonBaseBlock extends Internal.DirectionalBlock {
        constructor($$0: boolean, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static isPushable($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: boolean, $$5: Internal.Direction_): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        handler$cpm000$ftbchunks$onMoveBlocks(level: Internal.Level_, blockPos: BlockPos_, direction: Internal.Direction_, extending: boolean, cir: Internal.CallbackInfoReturnable_<any>, pistonStructureResolver: Internal.PistonStructureResolver_): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly TRIGGER_DROP: 2;
        static readonly TRIGGER_EXTEND: 0;
        static readonly EXTENDED: Internal.BooleanProperty;
        static readonly PLATFORM_THICKNESS: 4.0;
        static readonly TRIGGER_CONTRACT: 1;
    }
    type PistonBaseBlock_ = PistonBaseBlock;
    class DustParticleOptions extends Internal.DustParticleOptionsBase {
        constructor($$0: Vec3f_, $$1: number)
        getType(): Internal.ParticleType<Internal.DustParticleOptions>;
        get type(): Internal.ParticleType<Internal.DustParticleOptions>
        static readonly DESERIALIZER: Internal.ParticleOptions$Deserializer<Internal.DustParticleOptions>;
        static readonly REDSTONE: Internal.DustParticleOptions;
        static readonly REDSTONE_PARTICLE_COLOR: Vec3f;
        static readonly CODEC: Internal.Codec<Internal.DustParticleOptions>;
    }
    type DustParticleOptions_ = DustParticleOptions;
    class ClientboundSetTitleTextPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: net.minecraft.network.chat.Component_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getText(): net.minecraft.network.chat.Component;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get text(): net.minecraft.network.chat.Component
        get skippable(): boolean
    }
    type ClientboundSetTitleTextPacket_ = ClientboundSetTitleTextPacket;
    interface Script {
        abstract exec(arg0: Internal.Context_, arg1: Internal.Scriptable_): any;
        (arg0: Internal.Context, arg1: Internal.Scriptable): any;
    }
    type Script_ = Script;
    abstract class ConfigBase {
        constructor()
        registerAll(builder: Internal.ForgeConfigSpec$Builder_): void;
        abstract getName(): string;
        onLoad(): void;
        onReload(): void;
        get name(): string
        specification: Internal.ForgeConfigSpec;
    }
    type ConfigBase_ = ConfigBase;
    class CastingEnvironment$HeldItemInfo extends Internal.Record {
        constructor(stack: Internal.ItemStack_, hand: Internal.InteractionHand_)
        hand(): Internal.InteractionHand;
        stack(): Internal.ItemStack;
        component1(): Internal.ItemStack;
        component2(): Internal.InteractionHand;
    }
    type CastingEnvironment$HeldItemInfo_ = CastingEnvironment$HeldItemInfo;
    class AttributedCharacterIterator$Attribute implements Internal.Serializable {
        static readonly LANGUAGE: Internal.AttributedCharacterIterator$Attribute;
        static readonly READING: Internal.AttributedCharacterIterator$Attribute;
        static readonly INPUT_METHOD_SEGMENT: Internal.AttributedCharacterIterator$Attribute;
    }
    type AttributedCharacterIterator$Attribute_ = AttributedCharacterIterator$Attribute;
    abstract class Calendar implements Internal.Cloneable, Internal.Comparable<Internal.Calendar>, Internal.Serializable {
        clone(): any;
        getWeekYear(): number;
        getDisplayNames(arg0: number, arg1: number, arg2: Internal.Locale_): Internal.Map<string, number>;
        static getInstance(arg0: Internal.TimeZone_, arg1: Internal.Locale_): Internal.Calendar;
        setWeekDate(arg0: number, arg1: number, arg2: number): void;
        set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        toInstant(): Internal.Instant;
        isSet(arg0: number): boolean;
        abstract getMinimum(arg0: number): number;
        compareTo(arg0: Internal.Calendar_): number;
        set(arg0: number, arg1: number, arg2: number): void;
        static getAvailableLocales(): Internal.Locale[];
        setFirstDayOfWeek(arg0: number): void;
        compareTo(arg0: any): number;
        getTimeInMillis(): number;
        static getInstance(): Internal.Calendar;
        getCalendarType(): string;
        abstract add(arg0: number, arg1: number): void;
        set(arg0: number, arg1: number): void;
        isLenient(): boolean;
        abstract getLeastMaximum(arg0: number): number;
        setMinimalDaysInFirstWeek(arg0: number): void;
        isWeekDateSupported(): boolean;
        static getInstance(arg0: Internal.Locale_): Internal.Calendar;
        getDisplayName(arg0: number, arg1: number, arg2: Internal.Locale_): string;
        getWeeksInWeekYear(): number;
        getTime(): Internal.Date;
        setTimeInMillis(arg0: number): void;
        abstract roll(arg0: number, arg1: boolean): void;
        clear(arg0: number): void;
        abstract getGreatestMinimum(arg0: number): number;
        getMinimalDaysInFirstWeek(): number;
        after(arg0: any): boolean;
        setTime(arg0: Internal.Date_): void;
        abstract getMaximum(arg0: number): number;
        static getInstance(arg0: Internal.TimeZone_): Internal.Calendar;
        roll(arg0: number, arg1: number): void;
        clear(): void;
        setTimeZone(arg0: Internal.TimeZone_): void;
        getTimeZone(): Internal.TimeZone;
        getFirstDayOfWeek(): number;
        static getAvailableCalendarTypes(): Internal.Set<string>;
        get(arg0: number): number;
        getActualMinimum(arg0: number): number;
        set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        getActualMaximum(arg0: number): number;
        before(arg0: any): boolean;
        setLenient(arg0: boolean): void;
        get weekYear(): number
        get availableLocales(): Internal.Locale[]
        set firstDayOfWeek(arg0: number)
        get timeInMillis(): number
        get instance(): Internal.Calendar
        get calendarType(): string
        get lenient(): boolean
        set minimalDaysInFirstWeek(arg0: number)
        get weekDateSupported(): boolean
        get weeksInWeekYear(): number
        get time(): Internal.Date
        set timeInMillis(arg0: number)
        get minimalDaysInFirstWeek(): number
        set time(arg0: Internal.Date_)
        set timeZone(arg0: Internal.TimeZone_)
        get timeZone(): Internal.TimeZone
        get firstDayOfWeek(): number
        get availableCalendarTypes(): Internal.Set<string>
        set lenient(arg0: boolean)
        static readonly OCTOBER: 9;
        static readonly LONG: 2;
        static readonly TUESDAY: 3;
        static readonly AM_PM: 9;
        static readonly MONTH: 2;
        static readonly JULY: 6;
        static readonly MAY: 4;
        static readonly UNDECIMBER: 12;
        static readonly FEBRUARY: 1;
        static readonly WEEK_OF_MONTH: 4;
        static readonly DST_OFFSET: 16;
        static readonly WEDNESDAY: 4;
        static readonly NOVEMBER: 10;
        static readonly LONG_STANDALONE: 32770;
        static readonly SHORT_STANDALONE: 32769;
        static readonly AM: 0;
        static readonly HOUR_OF_DAY: 11;
        static readonly ALL_STYLES: 0;
        static readonly MARCH: 2;
        static readonly SATURDAY: 7;
        static readonly SHORT_FORMAT: 1;
        static readonly JANUARY: 0;
        static readonly NARROW_FORMAT: 4;
        static readonly FIELD_COUNT: 17;
        static readonly ERA: 0;
        static readonly YEAR: 1;
        static readonly DAY_OF_WEEK_IN_MONTH: 8;
        static readonly MILLISECOND: 14;
        static readonly WEEK_OF_YEAR: 3;
        static readonly AUGUST: 7;
        static readonly DATE: 5;
        static readonly MONDAY: 2;
        static readonly SHORT: 1;
        static readonly LONG_FORMAT: 2;
        static readonly APRIL: 3;
        static readonly FRIDAY: 6;
        static readonly NARROW_STANDALONE: 32772;
        static readonly SECOND: 13;
        static readonly ZONE_OFFSET: 15;
        static readonly SUNDAY: 1;
        static readonly DAY_OF_MONTH: 5;
        static readonly DAY_OF_YEAR: 6;
        static readonly THURSDAY: 5;
        static readonly PM: 1;
        static readonly JUNE: 5;
        static readonly HOUR: 10;
        static readonly DECEMBER: 11;
        static readonly SEPTEMBER: 8;
        static readonly MINUTE: 12;
        static readonly DAY_OF_WEEK: 7;
    }
    type Calendar_ = Calendar;
    class AttributeInstance {
        constructor($$0: Internal.Attribute_, $$1: Internal.Consumer_<Internal.AttributeInstance>)
        save(): Internal.CompoundTag;
        getModifiers(): Internal.Set<Internal.AttributeModifier>;
        removeModifier($$0: Internal.AttributeModifier_): void;
        hasModifier($$0: Internal.AttributeModifier_): boolean;
        setBaseValue($$0: number): void;
        removeModifiers(): void;
        removeModifier($$0: Internal.UUID_): void;
        getModifiers($$0: Internal.AttributeModifier$Operation_): Internal.Set<Internal.AttributeModifier>;
        getAttribute(): Internal.Attribute;
        getBaseValue(): number;
        addTransientModifier($$0: Internal.AttributeModifier_): void;
        replaceFrom($$0: Internal.AttributeInstance_): void;
        load($$0: Internal.CompoundTag_): void;
        getModifier($$0: Internal.UUID_): Internal.AttributeModifier;
        getValue(): number;
        removePermanentModifier($$0: Internal.UUID_): boolean;
        addPermanentModifier($$0: Internal.AttributeModifier_): void;
        get modifiers(): Internal.Set<Internal.AttributeModifier>
        set baseValue($$0: number)
        get attribute(): Internal.Attribute
        get baseValue(): number
        get value(): number
    }
    type AttributeInstance_ = AttributeInstance;
    abstract class BlockBuilder extends Internal.BuilderBase<Internal.Block> {
        constructor(i: ResourceLocation_)
        /**
         * Bounces entities that land on this block by bounciness * their fall velocity.
         * Do not make bounciness negative, as that is a recipe for a long and laggy trip to the void
        */
        bounciness(bounciness: number): this;
        /**
         * Note block instrument.
        */
        instrument(i: Internal.NoteBlockInstrument_): this;
        /**
         * Set what happens when an entity falls on the block. Do not use this for moving them, use bounce instead!
        */
        fallenOn(callbackJS: Internal.Consumer_<Internal.EntityFallenOnBlockCallbackJS>): this;
        /**
         * Tags the item with the given tag.
        */
        tagItem(tag: ResourceLocation_): this;
        /**
         * Set the block's model.
        */
        model(m: string): this;
        sandSoundType(): this;
        /**
         * Set the shape of the block.
        */
        box(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): this;
        /**
         * Makes the block a redstone conductor.
        */
        redstoneConductor(b: boolean): this;
        noSoundType(): this;
        /**
         * Modifies the block's item representation.
        */
        item(i: Internal.Consumer_<Internal.BlockItemBuilder>): this;
        /**
         * Set the default state of the block.
        */
        defaultState(callbackJS: Internal.Consumer_<Internal.BlockStateModifyCallbackJS>): this;
        /**
         * Set what happens when an entity steps on the block
         * This is called every tick for every entity standing on the block, so be careful what you do here.
        */
        steppedOn(callbackJS: Internal.Consumer_<Internal.EntitySteppedOnBlockCallbackJS>): this;
        textureAll(tex: Special.Texture): this;
        /**
         * Helper method for setting the render type of the block to `translucent` correctly.
        */
        defaultTranslucent(): this;
        /**
         * Sets the block's map color dynamically per block state. If unset, defaults to NONE.
        */
        dynamicMapColor(m: Internal.Function_<Internal.BlockState, any>): this;
        /**
         * Tags both the block and the item with the given tag.
        */
        tagBoth(tag: ResourceLocation_): this;
        /**
         * Makes the block view blocking.
        */
        viewBlocking(b: boolean): this;
        /**
         * Makes the block unbreakable.
        */
        unbreakable(): this;
        /**
         * Add a blockstate property to the block.
         * 
         * For example, facing, lit, etc.
        */
        property(property: Internal.Property_<any>): this;
        /**
         * Sets the blast resistance of the block. Defaults to 3.
        */
        resistance(r: number): this;
        gravelSoundType(): this;
        /**
         * Set the shape of the block.
        */
        box(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number, scale16: boolean): this;
        /**
         * Set the callback for determining the blocks state when placed.
        */
        placementState(callbackJS: Internal.Consumer_<Internal.BlockStateModifyPlacementCallbackJS>): this;
        /**
         * Set if the block can be replaced by something else.
        */
        canBeReplaced(callbackJS: Internal.Predicate_<Internal.CanBeReplacedCallbackJS>): this;
        /**
         * Sets random tick callback for this black.
        */
        randomTick(randomTickCallback: Internal.Consumer_<Internal.RandomTickCallbackJS>): this;
        /**
         * Set how this block reacts after an explosion. Note the block has already been destroyed at this point
        */
        exploded(callbackJS: Internal.Consumer_<Internal.BlockExplodedCallbackJS>): this;
        /**
         * Sets the light level of the block. Defaults to 0 (no light).
        */
        lightLevel(light: number): this;
        /**
         * Sets the display name for this object, e.g. `Stone`.
         * 
         * This will be overridden by a lang file if it exists.
        */
        displayName(name: net.minecraft.network.chat.Component_): Internal.BuilderBase<Internal.Block>;
        static createShape(boxes: Internal.List_<Internal.AABB>): Internal.VoxelShape;
        /**
         * Makes the block not be solid.
        */
        notSolid(): this;
        /**
         * Sets the block's map color. Defaults to NONE.
        */
        mapColor(m: Internal.MapColor_): this;
        /**
         * Sets the render type of the block. Can be `cutout`, `cutout_mipped`, `translucent`, or `basic`.
        */
        renderType(l: string): this;
        /**
         * Clears all drops for the block.
        */
        noDrops(): this;
        stoneSoundType(): this;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        setWaterlogged(waterlogged: boolean): this;
        createProperties(): Internal.BlockBehaviour$Properties;
        grassSoundType(): this;
        /**
         * Sets the block's sound type. Defaults to wood.
        */
        soundType(m: SoundType_): this;
        /**
         * Makes the block can be waterlogged.
        */
        waterlogged(): this;
        /**
         * Set the callback used for determining how the block rotates
        */
        rotateState(callbackJS: Internal.Consumer_<Internal.BlockStateRotateCallbackJS>): this;
        /**
         * Set how high you can jump on the block.
        */
        jumpFactor(f: number): this;
        /**
         * Set the color of a specific layer of the block.
        */
        color(color: Internal.BlockTintFunction_): this;
        /**
         * Set the callback used for right-clicking on the block
        */
        rightClick(callbackJS: Internal.Consumer_<Internal.BlockRightClickedEventJS>): this;
        /**
         * Makes the block require a tool to have drops when broken.
        */
        requiresTool(f: boolean): this;
        textureSide(direction: Internal.Direction_, tex: Special.Texture): this;
        texture(id: string, tex: Special.Texture): this;
        /**
         * Checks if the block can be waterlogged.
        */
        canBeWaterlogged(): boolean;
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        /**
         * Sets the hardness of the block. Defaults to 1.5.
         * 
         * Setting this to -1 will make the block unbreakable like bedrock.
        */
        hardness(h: number): this;
        glassSoundType(): this;
        /**
         * Creates a Block Entity for this block
        */
        blockEntity(callback: Internal.Consumer_<Internal.BlockEntityInfo>): this;
        /**
         * Set the block to have no corresponding item.
        */
        noItem(): this;
        transformObject(arg0: any): any;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getWaterlogged(): boolean;
        /**
         * Set the callback used for determining how the block is mirrored
        */
        mirrorState(callbackJS: Internal.Consumer_<Internal.BlockStateMirrorCallbackJS>): this;
        /**
         * Tags the block with the given tag.
        */
        tagBlock(tag: ResourceLocation_): this;
        /**
         * Set how slippery the block is.
        */
        slipperiness(f: number): this;
        woodSoundType(): this;
        /**
         * Sets the opacity of the block. Opaque blocks do not let light through.
        */
        opaque(o: boolean): this;
        /**
         * Makes mobs not spawn on the block.
        */
        noValidSpawns(b: boolean): this;
        material(material: string): this;
        transformObject(obj: Internal.Block_): Internal.Block;
        /**
         * Helper method for setting the render type of the block to `cutout` correctly.
        */
        defaultCutout(): this;
        /**
         * Makes the block transparent.
        */
        transparent(b: boolean): this;
        /**
         * Sets the block should be a full block or not, like cactus or doors.
        */
        fullBlock(f: boolean): this;
        /**
         * Makes the block not collide with entities.
        */
        noCollision(): this;
        /**
         * Set how this block bounces/moves entities that land on top of this. Do not use this to modify the block, use fallOn instead!
         * Use ctx.bounce(height) or ctx.setVelocity(x, y, z) to change the entities velocity.
        */
        afterFallenOn(callbackJS: Internal.Consumer_<Internal.AfterEntityFallenOnBlockCallbackJS>): this;
        /**
         * Makes the block suffocating.
        */
        suffocating(b: boolean): this;
        /**
         * Set the color of a specific layer of the block.
        */
        color(index: number, color: Internal.BlockTintFunction_): this;
        /**
         * Set how fast you can walk on the block.
         * 
         * Any value above 1 will make you walk insanely fast as your speed is multiplied by this value each tick.
         * 
         * Recommended values are between 0.1 and 1, useful for mimicking soul sand or ice.
        */
        speedFactor(f: number): this;
        /**
         * Makes the block require a tool to have drops when broken.
        */
        requiresTool(): this;
        cropSoundType(): this;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        set waterlogged(waterlogged: boolean)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        get waterlogged(): boolean
        lootTable: Internal.Consumer<Internal.LootBuilder>;
        blockstateJson: Internal.JsonObject;
        modelJson: Internal.JsonObject;
        randomTickCallback: Internal.Consumer<Internal.RandomTickCallbackJS>;
    }
    type BlockBuilder_ = BlockBuilder;
    class TransactionContext$Result extends Internal.Enum<Internal.TransactionContext$Result> {
        static values(): Internal.TransactionContext$Result[];
        wasCommitted(): boolean;
        static valueOf(name: string): Internal.TransactionContext$Result;
        wasAborted(): boolean;
        static readonly COMMITTED: Internal.TransactionContext$Result;
        static readonly ABORTED: Internal.TransactionContext$Result;
    }
    type TransactionContext$Result_ = TransactionContext$Result | "committed" | "aborted";
    class EdgeData implements Internal.ISwitchDisabledEdge {
        constructor(edge: Internal.TrackEdge_)
        getEffectiveEdgeGroupId(graph: Internal.TrackGraph_): Internal.UUID;
        next(minPosition: number): Internal.TrackEdgePoint;
        setEnabled(enabled: boolean): void;
        setAutomaticallySelected(): void;
        static isAutomatic(edge: Internal.TrackEdge_): boolean;
        next<T extends Internal.TrackEdgePoint>(type: Internal.EdgePointType_<T>, minPosition: number): T;
        isEnabled(): boolean;
        getIntersections(): Internal.List<Internal.TrackEdgeIntersection>;
        addIntersection(graph: Internal.TrackGraph_, id: Internal.UUID_, position: number, target1: Internal.TrackNode_, target2: Internal.TrackNode_, targetPosition: number): void;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        isAutomaticallySelected(): boolean;
        static isEnabled(edge: Internal.TrackEdge_): boolean;
        setAutomatic(automatic: boolean): void;
        static automaticallySelect(edge: Internal.TrackEdge_): void;
        setSingleSignalGroup(graph: Internal.TrackGraph_, singleSignalGroup: Internal.UUID_): void;
        hasIntersections(): boolean;
        hasPoints(): boolean;
        refreshIntersectingSignalGroups(graph: Internal.TrackGraph_): void;
        getSingleSignalGroup(): Internal.UUID;
        ackAutomaticSelection(): void;
        static read(nbt: Internal.CompoundTag_, edge: Internal.TrackEdge_, graph: Internal.TrackGraph_, dimensions: Internal.DimensionPalette_): Internal.EdgeData;
        isAutomatic(): boolean;
        getAutomaticallySelectedPriority(): number;
        static isDisabled(edge: Internal.TrackEdge_): boolean;
        hasSignalBoundaries(): boolean;
        get<T extends Internal.TrackEdgePoint>(type: Internal.EdgePointType_<T>, exactPosition: number): T;
        removeIntersection(graph: Internal.TrackGraph_, id: Internal.UUID_): void;
        removePoint(graph: Internal.TrackGraph_, point: Internal.TrackEdgePoint_): void;
        getPoints(): Internal.List<Internal.TrackEdgePoint>;
        getGroupAtPosition(graph: Internal.TrackGraph_, position: number): Internal.UUID;
        addPoint<T extends Internal.TrackEdgePoint>(graph: Internal.TrackGraph_, point: Internal.TrackEdgePoint_): void;
        set enabled(enabled: boolean)
        get enabled(): boolean
        get intersections(): Internal.List<Internal.TrackEdgeIntersection>
        get automaticallySelected(): boolean
        set automatic(automatic: boolean)
        get singleSignalGroup(): Internal.UUID
        get automatic(): boolean
        get automaticallySelectedPriority(): number
        get points(): Internal.List<Internal.TrackEdgePoint>
        static readonly passiveGroup: Internal.UUID;
    }
    type EdgeData_ = EdgeData;
    interface ScheduledExecutorService extends Internal.ExecutorService {
        abstract scheduleAtFixedRate(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): Internal.ScheduledFuture<any>;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): T;
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): Internal.List<Internal.Future<T>>;
        abstract isShutdown(): boolean;
        abstract submit<T>(arg0: Internal.Callable_<T>): Internal.Future<T>;
        abstract shutdownNow(): Internal.List<Internal.Runnable>;
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>): Internal.List<Internal.Future<T>>;
        abstract schedule(arg0: Internal.Runnable_, arg1: number, arg2: Internal.TimeUnit_): Internal.ScheduledFuture<any>;
        abstract scheduleWithFixedDelay(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): Internal.ScheduledFuture<any>;
        abstract shutdown(): void;
        abstract awaitTermination(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract schedule<V>(arg0: Internal.Callable_<V>, arg1: number, arg2: Internal.TimeUnit_): Internal.ScheduledFuture<V>;
        close(): void;
        abstract submit<T>(arg0: Internal.Runnable_, arg1: T): Internal.Future<T>;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>): T;
        abstract submit(arg0: Internal.Runnable_): Internal.Future<any>;
        abstract execute(arg0: Internal.Runnable_): void;
        abstract isTerminated(): boolean;
        get shutdown(): boolean
        get terminated(): boolean
    }
    type ScheduledExecutorService_ = ScheduledExecutorService;
    class ProcessingRecipeSerializer <T extends Internal.ProcessingRecipe<any>> implements Internal.RecipeSerializer<T> {
        constructor(factory: Internal.ProcessingRecipeBuilder$ProcessingRecipeFactory_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetwork(id: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): T;
        write(json: Internal.JsonObject_, recipe: T): void;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: T): void;
        getFactory(): Internal.ProcessingRecipeBuilder$ProcessingRecipeFactory<T>;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        get factory(): Internal.ProcessingRecipeBuilder$ProcessingRecipeFactory<T>
    }
    type ProcessingRecipeSerializer_<T extends Internal.ProcessingRecipe<any>> = ProcessingRecipeSerializer<T>;
    class PortableCellMenuHost extends Internal.ItemMenuHost implements Internal.IPortableTerminal {
        constructor(player: Internal.Player_, slot: number, item: Internal.AbstractPortableCell_, itemStack: Internal.ItemStack_, returnMainMenu: Internal.BiConsumer_<Internal.Player, Internal.ISubMenu>)
        isUpgradedWith(upgradeCard: Internal.ItemLike_): boolean;
        getInstalledUpgrades(upgradeCard: Internal.ItemLike_): number;
        getCloseHotkey(): string;
        getMainMenuIcon(): Internal.ItemStack;
        getConfigManager(): Internal.IConfigManager;
        extractAEPower(amt: number, mode: Internal.Actionable_, usePowerMultiplier: Internal.PowerMultiplier_): number;
        getInventory(): Internal.MEStorage;
        returnToMainMenu(player: Internal.Player_, subMenu: Internal.ISubMenu_): void;
        get closeHotkey(): string
        get mainMenuIcon(): Internal.ItemStack
        get configManager(): Internal.IConfigManager
        get inventory(): Internal.MEStorage
    }
    type PortableCellMenuHost_ = PortableCellMenuHost;
    class LootTableProvider$SubProviderEntry extends Internal.Record {
        constructor($$0: Internal.Supplier_<Internal.LootTableSubProvider>, $$1: Internal.LootContextParamSet_)
        paramSet(): Internal.LootContextParamSet;
        provider(): Internal.Supplier<Internal.LootTableSubProvider>;
    }
    type LootTableProvider$SubProviderEntry_ = LootTableProvider$SubProviderEntry;
    class Display$TextDisplay extends Internal.Display {
        constructor($$0: Internal.EntityType_<any>, $$1: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        static getAlign($$0: number): Internal.Display$TextDisplay$Align;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        textRenderState(): Internal.Display$TextDisplay$TextRenderState;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        cacheDisplay($$0: Internal.Display$TextDisplay$LineSplitter_): Internal.Display$TextDisplay$CachedInfo;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        static readonly FLAG_SEE_THROUGH: 2;
        static readonly TAG_TEXT: "text";
        static readonly INITIAL_BACKGROUND: 1073741824;
        static readonly FLAG_SHADOW: 1;
        static readonly FLAG_ALIGN_LEFT: 8;
        static readonly FLAG_ALIGN_RIGHT: 16;
        static readonly FLAG_USE_DEFAULT_BACKGROUND: 4;
    }
    type Display$TextDisplay_ = Display$TextDisplay;
    interface BlockAndTintGetter extends Internal.BlockGetter {
        abstract getBlockTint(arg0: BlockPos_, arg1: Internal.ColorResolver_): number;
        getMinSection(): number;
        abstract getShade(arg0: Internal.Direction_, arg1: boolean): number;
        abstract getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        abstract getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        abstract getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        abstract getHeight(): number;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        canSeeSky($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        abstract getFluidState(arg0: BlockPos_): Internal.FluidState;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getSectionsCount(): number;
        abstract getMinBuildHeight(): number;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get lightEngine(): Internal.LevelLightEngine
        get height(): number
        get sectionsCount(): number
        get minBuildHeight(): number
        get maxLightLevel(): number
    }
    type BlockAndTintGetter_ = BlockAndTintGetter;
    class BlockDestructionProgress implements Internal.Comparable<Internal.BlockDestructionProgress>, Internal.BlockDestructionProgressExtension {
        constructor($$0: number, $$1: BlockPos_)
        getUpdatedRenderTick(): number;
        getProgress(): number;
        getPos(): BlockPos;
        compareTo($$0: Internal.BlockDestructionProgress_): number;
        create$setExtraPositions(positions: Internal.Set_<any>): void;
        create$getExtraPositions(): Internal.Set<any>;
        updateTick($$0: number): void;
        compareTo(arg0: any): number;
        setProgress($$0: number): void;
        getId(): number;
        get updatedRenderTick(): number
        get progress(): number
        get pos(): BlockPos
        set progress($$0: number)
        get id(): number
    }
    type BlockDestructionProgress_ = BlockDestructionProgress;
    class DrinkableItem extends Internal.ConsumableItem {
        constructor(properties: Internal.Item$Properties_, hasFoodEffectTooltip: boolean)
        constructor(properties: Internal.Item$Properties_)
        constructor(properties: Internal.Item$Properties_, hasPotionEffectTooltip: boolean, hasCustomTooltip: boolean)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DrinkableItem_ = DrinkableItem;
    class ChuteBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveGoggleInformation, Internal.SidedStorageBlockEntity, Internal.CustomRenderBoundingBoxBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        setItem(stack: Internal.ItemStack_, insertionPos: number): void;
        getItemMotion(): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        updatePull(): void;
        updatePush(branchCount: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setItem(stack: Internal.ItemStack_): void;
        onLoad(): void;
        getItemStorage(face: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        canDirectlyInsertCached(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        blockBelowChanged(): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        propagatePush(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        onAdded(): void;
        getRenderBoundingBox(): Internal.AABB;
        get itemMotion(): number
        set item(stack: Internal.ItemStack_)
        get item(): Internal.ItemStack
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type ChuteBlockEntity_ = ChuteBlockEntity;
    abstract class TinyMultiblockControllerBlock extends Internal.ControllerBlock {
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type TinyMultiblockControllerBlock_ = TinyMultiblockControllerBlock;
    class AttributeModifier$Operation extends Internal.Enum<Internal.AttributeModifier$Operation> {
        static valueOf($$0: string): Internal.AttributeModifier$Operation;
        static fromValue($$0: number): Internal.AttributeModifier$Operation;
        static values(): Internal.AttributeModifier$Operation[];
        toValue(): number;
        static readonly MULTIPLY_BASE: Internal.AttributeModifier$Operation;
        static readonly MULTIPLY_TOTAL: Internal.AttributeModifier$Operation;
        static readonly ADDITION: Internal.AttributeModifier$Operation;
    }
    type AttributeModifier$Operation_ = "addition" | AttributeModifier$Operation | "multiply_total" | "multiply_base";
    class SlimeFluid$Source extends Internal.SlimeFluid {
        constructor(properties: any_)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type SlimeFluid$Source_ = SlimeFluid$Source;
    class ComplexItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getUpdatePacket($$0: Internal.ItemStack_, $$1: Internal.Level_, $$2: Internal.Player_): Internal.Packet<any>;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ComplexItem_ = ComplexItem;
    class ItemStackHandler {
        constructor()
        constructor(size: number)
        constructor(stacks: Internal.NonNullList_<Internal.ItemStack>)
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getSlotLimit(slot: number): number;
        setSize(size: number): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        getStackInSlot(slot: number): Internal.ItemStack;
        serializeNBT(): Internal.CompoundTag;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        get slots(): number
        set size(size: number)
    }
    type ItemStackHandler_ = ItemStackHandler;
    abstract class AbstractMinecart extends Internal.Entity implements Internal.AbstractMinecartAccessor, io.github.fabricators_of_create.porting_lib.entity.extensions.AbstractMinecartExtensions, Internal.AbstractMinecartExtensions {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        activateMinecart($$0: number, $$1: number, $$2: number, $$3: boolean): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getPos($$0: number, $$1: number, $$2: number): Vec3d;
        setCustomDisplay($$0: boolean): void;
        getCurrentRailPos(): BlockPos;
        setHurtTime($$0: number): void;
        setDamage($$0: number): void;
        getDisplayOffset(): number;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        isLiving(): boolean;
        abstract getMinecartType(): Internal.AbstractMinecart$Type;
        static tickEntity(entity: Internal.Entity_): void;
        moveMinecartOnRail(pos: BlockPos_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        getDisplayName(): net.minecraft.network.chat.Component;
        getMaxSpeedOnRail(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        abstract getDropItem(): Internal.Item;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        destroy($$0: DamageSource_): void;
        hasCustomDisplay(): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        handler$zio004$ad_astra$adastra$tick(ci: Internal.CallbackInfo_): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setDisplayOffset($$0: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        playSound(id: Internal.SoundEvent_): void;
        getDamage(): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getPosOffs($$0: number, $$1: number, $$2: number, $$3: number): Vec3d;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getDisplayBlockState(): Internal.BlockState;
        getDefaultDisplayOffset(): number;
        getType(): string;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getDefaultDisplayBlockState(): Internal.BlockState;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        sophisticatedInvalidateCaps(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        port_lib$getMaxSpeed(): number;
        getHurtTime(): number;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setHurtDir($$0: number): void;
        create$getController(): Internal.MinecartController;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        static createMinecart($$0: Internal.Level_, $$1: number, $$2: number, $$3: number, $$4: Internal.AbstractMinecart$Type_): Internal.AbstractMinecart;
        serializeNBT(): Internal.Tag;
        getHurtDir(): number;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        lithiumOnBlockCacheDeleted(): void;
        runCommand(command: string): number;
        setDisplayBlockState($$0: Internal.BlockState_): void;
        set customDisplay($$0: boolean)
        get currentRailPos(): BlockPos
        set hurtTime($$0: number)
        set damage($$0: number)
        get displayOffset(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get minecartType(): Internal.AbstractMinecart$Type
        get displayName(): net.minecraft.network.chat.Component
        get maxSpeedOnRail(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get dropItem(): Internal.Item
        get teamId(): string
        get facing(): Internal.Direction
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        set displayOffset($$0: number)
        get frame(): boolean
        get damage(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get displayBlockState(): Internal.BlockState
        get defaultDisplayOffset(): number
        get type(): string
        get block(): Internal.BlockContainerJS
        get defaultDisplayBlockState(): Internal.BlockState
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get hurtTime(): number
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set hurtDir($$0: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get hurtDir(): number
        set dynamicLightEnabled(enabled: boolean)
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set displayBlockState($$0: Internal.BlockState_)
    }
    type AbstractMinecart_ = AbstractMinecart;
    class EnergyNetwork {
        constructor(world: Internal.Level_)
        push(energy: number, simulate: boolean): number;
        isValid(): boolean;
        demand(demand: number): number;
        static nextNode(level: Internal.Level_, en: Internal.EnergyNetwork_, visited: Internal.Map_<string, Internal.IWireNode>, current: Internal.IWireNode_, index: number): Internal.EnergyNetwork;
        getPulled(): number;
        getPushed(): number;
        push(energy: number): number;
        getBuff(): number;
        invalidate(): void;
        tick(index: number): void;
        removed(): void;
        pull(energy: number, simulate: boolean): number;
        getDemand(): number;
        getMaxBuff(): number;
        pull(max: number): number;
        getId(): number;
        get valid(): boolean
        get pulled(): number
        get pushed(): number
        get buff(): number
        get demand(): number
        get maxBuff(): number
        get id(): number
    }
    type EnergyNetwork_ = EnergyNetwork;
    interface CreativeModeTabKJS {
        abstract kjs$setIcon(arg0: Internal.ItemStack_): void;
        abstract kjs$setDisplayName(arg0: net.minecraft.network.chat.Component_): void;
    }
    type CreativeModeTabKJS_ = CreativeModeTabKJS;
    class DeathCounterDisplaySource extends Internal.StatTrackingDisplaySource {
        constructor()
    }
    type DeathCounterDisplaySource_ = DeathCounterDisplaySource;
    class WaterWorkerEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
    }
    type WaterWorkerEnchantment_ = WaterWorkerEnchantment;
    class ThornsEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
        static shouldHit($$0: number, $$1: Internal.RandomSource_): boolean;
        static getDamage($$0: number, $$1: Internal.RandomSource_): number;
    }
    type ThornsEnchantment_ = ThornsEnchantment;
    class ChatLog {
        constructor($$0: number)
        lookup($$0: number): Internal.LoggedChatEvent;
        start(): number;
        end(): number;
        static codec($$0: number): Internal.Codec<Internal.ChatLog>;
        push($$0: Internal.LoggedChatEvent_): void;
    }
    type ChatLog_ = ChatLog;
    interface EffectsProperties {
        abstract getWaterColor(): number;
        abstract getAmbientLoopSound(): Internal.Optional<Internal.Holder<Internal.SoundEvent>>;
        abstract getBackgroundMusic(): Internal.Optional<Internal.Music>;
        abstract getGrassColorModifier(): Internal.BiomeSpecialEffects$GrassColorModifier;
        abstract getAmbientAdditionsSound(): Internal.Optional<Internal.AmbientAdditionsSettings>;
        abstract getFoliageColorOverride(): Internal.OptionalInt;
        abstract getAmbientMoodSound(): Internal.Optional<Internal.AmbientMoodSettings>;
        abstract getWaterFogColor(): number;
        abstract getFogColor(): number;
        abstract getAmbientParticle(): Internal.Optional<Internal.AmbientParticleSettings>;
        abstract getSkyColor(): number;
        abstract getGrassColorOverride(): Internal.OptionalInt;
        get waterColor(): number
        get ambientLoopSound(): Internal.Optional<Internal.Holder<Internal.SoundEvent>>
        get backgroundMusic(): Internal.Optional<Internal.Music>
        get grassColorModifier(): Internal.BiomeSpecialEffects$GrassColorModifier
        get ambientAdditionsSound(): Internal.Optional<Internal.AmbientAdditionsSettings>
        get foliageColorOverride(): Internal.OptionalInt
        get ambientMoodSound(): Internal.Optional<Internal.AmbientMoodSettings>
        get waterFogColor(): number
        get fogColor(): number
        get ambientParticle(): Internal.Optional<Internal.AmbientParticleSettings>
        get skyColor(): number
        get grassColorOverride(): Internal.OptionalInt
    }
    type EffectsProperties_ = EffectsProperties;
    interface WorldCreationContext$OptionsModifier extends Internal.UnaryOperator<Internal.WorldOptions> {
        identity<T>(): Internal.UnaryOperator<T>;
        abstract apply(arg0: Internal.WorldOptions_): Internal.WorldOptions;
        andThen<V>(arg0: Internal.Function_<Internal.WorldOptions, V>): Internal.Function<Internal.WorldOptions, V>;
        compose<V>(arg0: Internal.Function_<V, Internal.WorldOptions>): Internal.Function<V, Internal.WorldOptions>;
        (arg0: Internal.WorldOptions): Internal.WorldOptions_;
    }
    type WorldCreationContext$OptionsModifier_ = WorldCreationContext$OptionsModifier;
    class Weight {
        static of($$0: number): Internal.Weight;
        asInt(): number;
        static readonly CODEC: Internal.Codec<Internal.Weight>;
    }
    type Weight_ = Weight;
    interface AccessorNavigation {
        abstract getCurrentPath(): Internal.List<Internal.Couple<Internal.TrackNode>>;
        get currentPath(): Internal.List<Internal.Couple<Internal.TrackNode>>
        (): Internal.List_<Internal.Couple<Internal.TrackNode>>;
    }
    type AccessorNavigation_ = AccessorNavigation;
    interface WorldlyContainerHolder {
        abstract getContainer(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.WorldlyContainer;
        (arg0: Internal.BlockState, arg1: Internal.LevelAccessor, arg2: BlockPos): Internal.WorldlyContainer_;
    }
    type WorldlyContainerHolder_ = WorldlyContainerHolder;
    class ClientChunkCache$Storage {
        constructor(arg0: Internal.ClientChunkCache_, arg1: number)
        replace($$0: number, $$1: Internal.LevelChunk_, $$2: Internal.LevelChunk_): Internal.LevelChunk;
        getIndex($$0: number, $$1: number): number;
        getChunk($$0: number): Internal.LevelChunk;
        inRange($$0: number, $$1: number): boolean;
        replace($$0: number, $$1: Internal.LevelChunk_): void;
        viewCenterX: number;
        viewCenterZ: number;
        readonly chunks: Internal.AtomicReferenceArray<Internal.LevelChunk>;
    }
    type ClientChunkCache$Storage_ = ClientChunkCache$Storage;
    class OwoUIAdapter <R extends Internal.ParentComponent> implements Internal.NarratableEntry, Internal.GuiEventListener, Internal.Renderable {
        charTyped(chr: string, modifiers: number): boolean;
        isFocused(): boolean;
        y(): number;
        x(): number;
        static create<R extends Internal.ParentComponent>(screen: Internal.Screen_, rootComponentMaker: Internal.BiFunction_<Internal.Sizing, Internal.Sizing, R>): Internal.OwoUIAdapter<R>;
        setFocused(focused: boolean): void;
        isActive(): boolean;
        getTabOrderGroup(): number;
        mouseScrolled(mouseX: number, mouseY: number, amount: number): boolean;
        mouseClicked(mouseX: number, mouseY: number, button: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        static isRendering(): boolean;
        static createWithoutScreen<R extends Internal.ParentComponent>(x: number, y: number, width: number, height: number, rootComponentMaker: Internal.BiFunction_<Internal.Sizing, Internal.Sizing, R>): Internal.OwoUIAdapter<R>;
        mouseDragged(mouseX: number, mouseY: number, button: number, deltaX: number, deltaY: number): boolean;
        mouseMoved($$0: number, $$1: number): void;
        getRectangle(): Internal.ScreenRectangle;
        toggleInspector(): boolean;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        inflateAndMount(): void;
        narrationPriority(): Internal.NarratableEntry$NarrationPriority;
        height(): number;
        mouseReleased(mouseX: number, mouseY: number, button: number): boolean;
        keyPressed(keyCode: number, scanCode: number, modifiers: number): boolean;
        getCurrentFocusPath(): Internal.ComponentPath;
        updateNarration(builder: Internal.NarrationElementOutput_): void;
        toggleGlobalInspector(): boolean;
        width(): number;
        render(context: Internal.GuiGraphics_, mouseX: number, mouseY: number, partialTicks: number): void;
        dispose(): void;
        moveAndResize(x: number, y: number, width: number, height: number): void;
        isMouseOver(mouseX: number, mouseY: number): boolean;
        get focused(): boolean
        set focused(focused: boolean)
        get active(): boolean
        get tabOrderGroup(): number
        get rendering(): boolean
        get rectangle(): Internal.ScreenRectangle
        get currentFocusPath(): Internal.ComponentPath
        globalInspector: boolean;
        readonly rootComponent: R;
        readonly cursorAdapter: Internal.CursorAdapter;
        inspectorZOffset: number;
        enableInspector: boolean;
    }
    type OwoUIAdapter_<R extends Internal.ParentComponent> = OwoUIAdapter<R>;
    interface InstantSource {
        tick(arg0: Internal.InstantSource_, arg1: Duration_): this;
        offset(arg0: Internal.InstantSource_, arg1: Duration_): this;
        fixed(arg0: Internal.Instant_): this;
        abstract instant(): Internal.Instant;
        system(): this;
        withZone(arg0: Internal.ZoneId_): Internal.Clock;
        millis(): number;
        (): Internal.Instant_;
    }
    type InstantSource_ = InstantSource;
    class DigitalAdapterDisplaySource extends Internal.DisplaySource {
        constructor()
    }
    type DigitalAdapterDisplaySource_ = DigitalAdapterDisplaySource;
    class BlockDragonForgeCore extends Internal.BaseEntityBlock implements Internal.INoTab, Internal.IDragonProof {
        constructor(isFire: number, activated: boolean)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(world: Internal.Level_, state: Internal.BlockState_, entityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        static name(dragonType: number, activated: boolean): string;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static setState(dragonType: number, active: boolean, worldIn: Internal.Level_, pos: BlockPos_): void;
        shouldBeInTab(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getItem(world: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): Internal.ItemStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockDragonForgeCore_ = BlockDragonForgeCore;
    class GameRules$Category extends Internal.Enum<Internal.GameRules$Category> {
        static valueOf($$0: string): Internal.GameRules$Category;
        static values(): Internal.GameRules$Category[];
        getDescriptionId(): string;
        get descriptionId(): string
        static readonly CHAT: Internal.GameRules$Category;
        static readonly MISC: Internal.GameRules$Category;
        static readonly DROPS: Internal.GameRules$Category;
        static readonly UPDATES: Internal.GameRules$Category;
        static readonly PLAYER: Internal.GameRules$Category;
        static readonly MOBS: Internal.GameRules$Category;
        static readonly SPAWNING: Internal.GameRules$Category;
    }
    type GameRules$Category_ = "chat" | "updates" | "misc" | "drops" | "player" | "mobs" | "spawning" | GameRules$Category;
    class ProtoChunkTicks <T> implements Internal.TickContainerAccess<T>, Internal.SerializableTickContainer<T> {
        constructor()
        count(): number;
        static load<T>($$0: Internal.ListTag_, $$1: Internal.Function_<string, Internal.Optional<T>>, $$2: Internal.ChunkPos_): Internal.ProtoChunkTicks<T>;
        schedule($$0: Internal.ScheduledTick_<T>): void;
        hasScheduledTick($$0: BlockPos_, $$1: T): boolean;
        save($$0: number, $$1: Internal.Function_<T, string>): Internal.Tag;
        scheduledTicks(): Internal.List<Internal.SavedTick<T>>;
    }
    type ProtoChunkTicks_<T> = ProtoChunkTicks<T>;
    class EverlastingUpgradeItem$Wrapper extends Internal.UpgradeWrapperBase<Internal.EverlastingUpgradeItem$Wrapper, Internal.EverlastingUpgradeItem> {
        constructor(backpackWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        onAdded(): void;
        onBeforeRemoved(): void;
    }
    type EverlastingUpgradeItem$Wrapper_ = EverlastingUpgradeItem$Wrapper;
    class ShapedRetexturedRecipe extends Internal.ShapedRecipe {
        static bookshelf$dissolvePattern(pattern: string[], ingredients: Internal.Map_<string, Internal.Ingredient>, width: number, height: number): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        static bookshelf$shrink(...pattern: string[]): string[];
        static bookshelf$patternFromJson(json: Internal.JsonArray_): string[];
        getOrCreateId(): ResourceLocation;
        getRecipeOutput(texture: Internal.Item_): Internal.ItemStack;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        static bookshelf$keyFromJson($$0: Internal.JsonObject_): Internal.Map<string, Internal.Ingredient>;
        getTexture(): Internal.Ingredient;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get texture(): Internal.Ingredient
        get mod(): string
    }
    type ShapedRetexturedRecipe_ = ShapedRetexturedRecipe;
    interface IExtendedGuiGraphics {
        abstract setCurrentTooltipStack(arg0: Internal.ItemStack_): void;
        abstract getCurrentTooltipStack(): Internal.ItemStack;
        set currentTooltipStack(arg0: Internal.ItemStack_)
        get currentTooltipStack(): Internal.ItemStack
    }
    type IExtendedGuiGraphics_ = IExtendedGuiGraphics;
    interface MouseDrag {
        newStream(): Internal.EventStream<Internal.MouseDrag>;
        abstract onMouseDrag(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): boolean;
        (arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): boolean;
    }
    type MouseDrag_ = MouseDrag;
    class UniversalAttractorItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type UniversalAttractorItem_ = UniversalAttractorItem;
    abstract class BlockCircleComponent extends Internal.Block implements Internal.ICircleComponent {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        abstract normalDir(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.Level_, arg3: number): Internal.Direction;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        abstract particleHeight(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.Level_): number;
        static sfx(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_, impetus: Internal.BlockEntityAbstractImpetus_, success: boolean): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static placeStateDirAndSneak(stock: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        abstract acceptControlFlow(arg0: Internal.CastingImage_, arg1: Internal.CircleCastEnv_, arg2: Internal.Direction_, arg3: BlockPos_, arg4: Internal.BlockState_, arg5: Internal.ServerLevel_): Internal.ICircleComponent$ControlFlow;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        abstract canEnterFromDirection(arg0: Internal.Direction_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.ServerLevel_): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        endEnergized(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_): Internal.BlockState;
        isEnergized(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_): boolean;
        fakeThrowMishap(pos: BlockPos_, bs: Internal.BlockState_, image: Internal.CastingImage_, env: Internal.CircleCastEnv_, mishap: Internal.Mishap_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        startEnergized(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        abstract possibleExitDirections(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.Level_): Internal.EnumSet<Internal.Direction>;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static normalDirOfOther(other: BlockPos_, world: Internal.Level_, recursionLeft: number): Internal.Direction;
        normalDir(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_): Internal.Direction;
        emi(): Internal.EmiStack;
        exitPositionFromDirection(pos: BlockPos_, dir: Internal.Direction_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Direction>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly ENERGIZED: Internal.BooleanProperty;
    }
    type BlockCircleComponent_ = BlockCircleComponent;
    interface PlacementModifierType <P extends Internal.PlacementModifier> {
        abstract codec(): Internal.Codec<P>;
        (): Internal.Codec_<P>;
        readonly SURFACE_RELATIVE_THRESHOLD_FILTER: Internal.PlacementModifierType<Internal.SurfaceRelativeThresholdFilter>;
        readonly IN_SQUARE: Internal.PlacementModifierType<Internal.InSquarePlacement>;
        readonly HEIGHTMAP: Internal.PlacementModifierType<Internal.HeightmapPlacement>;
        readonly HEIGHT_RANGE: Internal.PlacementModifierType<Internal.HeightRangePlacement>;
        readonly BIOME_FILTER: Internal.PlacementModifierType<net.minecraft.world.level.levelgen.placement.BiomeFilter>;
        readonly RANDOM_OFFSET: Internal.PlacementModifierType<Internal.RandomOffsetPlacement>;
        readonly BLOCK_PREDICATE_FILTER: Internal.PlacementModifierType<Internal.BlockPredicateFilter>;
        readonly CARVING_MASK_PLACEMENT: Internal.PlacementModifierType<Internal.CarvingMaskPlacement>;
        readonly NOISE_BASED_COUNT: Internal.PlacementModifierType<Internal.NoiseBasedCountPlacement>;
        readonly ENVIRONMENT_SCAN: Internal.PlacementModifierType<Internal.EnvironmentScanPlacement>;
        readonly SURFACE_WATER_DEPTH_FILTER: Internal.PlacementModifierType<Internal.SurfaceWaterDepthFilter>;
        readonly COUNT_ON_EVERY_LAYER: Internal.PlacementModifierType<Internal.CountOnEveryLayerPlacement>;
        readonly COUNT: Internal.PlacementModifierType<Internal.CountPlacement>;
        readonly NOISE_THRESHOLD_COUNT: Internal.PlacementModifierType<Internal.NoiseThresholdCountPlacement>;
        readonly RARITY_FILTER: Internal.PlacementModifierType<Internal.RarityFilter>;
    }
    type PlacementModifierType_<P extends Internal.PlacementModifier> = PlacementModifierType<P> | Special.PlacementModifierType;
    class FoodProvider {
        consume(player: Internal.Player_, world: Internal.Level_, nbtApplier: Internal.Consumer_<Internal.ItemStack>): boolean;
        static create(item: Internal.Item_, divider: number): Internal.FoodProvider;
        isEmpty(): boolean;
        getFood(): Internal.Item;
        getDivider(): number;
        get empty(): boolean
        get food(): Internal.Item
        get divider(): number
        static readonly CUSTOM_PROVIDERS: {[key: Internal.SuspiciousStewItem]: any, [key: Internal.AirItem]: Internal.FoodProvider, [key: Internal.ExperienceBottleItem]: any, [key: Internal.MilkBucketItem]: any};
        static readonly CODEC: Internal.Codec<Internal.FoodProvider>;
        static readonly EMPTY: Internal.FoodProvider;
    }
    type FoodProvider_ = FoodProvider;
    class ModifierEntry implements Internal.Comparable<Internal.ModifierEntry> {
        constructor(modifier: Internal.Modifier_, level: number)
        constructor(id: Internal.ModifierId_, level: number)
        constructor(modifier: Internal.LazyModifier_, level: number)
        write(buffer: Internal.FriendlyByteBuf_): void;
        getLevel(): number;
        static read(buffer: Internal.FriendlyByteBuf_): Internal.ModifierEntry;
        toNbt(): Internal.CompoundTag;
        isBound(): boolean;
        static fromNbt(tag: Internal.CompoundTag_): Internal.ModifierEntry;
        getId(): Internal.ModifierId;
        getHook<T>(hook: Internal.ModifierHook_<T>): T;
        matches(modifier: Internal.Modifier_): boolean;
        toJson(): Internal.JsonObject;
        compareTo(arg0: any): number;
        matches(tag: Internal.TagKey_<Internal.Modifier>): boolean;
        compareTo(other: Internal.ModifierEntry_): number;
        withLevel(level: number): this;
        getEffectiveLevel(tool: Internal.IToolContext_): number;
        getLazyModifier(): Internal.LazyModifier;
        matches(id: Internal.ModifierId_): boolean;
        getModifier(): Internal.Modifier;
        static fromJson(json: Internal.JsonObject_): Internal.ModifierEntry;
        get level(): number
        get bound(): boolean
        get id(): Internal.ModifierId
        get lazyModifier(): Internal.LazyModifier
        get modifier(): Internal.Modifier
        static readonly SERIALIZER: Internal.ModifierEntry$Serializer;
    }
    type ModifierEntry_ = ModifierEntry;
    class MutableObject <T> implements Internal.Mutable<T>, Internal.Serializable {
        constructor()
        constructor(arg0: T)
        setValue(arg0: T): void;
        getValue(): T;
        set value(arg0: T)
        get value(): T
    }
    type MutableObject_<T> = MutableObject<T>;
    interface LongToDoubleFunction {
        abstract applyAsDouble(arg0: number): number;
        (arg0: number): number;
    }
    type LongToDoubleFunction_ = LongToDoubleFunction;
    interface TravellingPoint$IPortalListener extends Internal.Predicate<Internal.Couple<Internal.TrackNodeLocation>> {
        abstract test(arg0: Internal.Couple_<Internal.TrackNodeLocation>): boolean;
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        negate(): Internal.Predicate<Internal.Couple<Internal.TrackNodeLocation>>;
        or(arg0: Internal.Predicate_<Internal.Couple<Internal.TrackNodeLocation>>): Internal.Predicate<Internal.Couple<Internal.TrackNodeLocation>>;
        and(arg0: Internal.Predicate_<Internal.Couple<Internal.TrackNodeLocation>>): Internal.Predicate<Internal.Couple<Internal.TrackNodeLocation>>;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
        (arg0: Internal.Couple<Internal.TrackNodeLocation>): boolean;
    }
    type TravellingPoint$IPortalListener_ = TravellingPoint$IPortalListener;
    interface Object2FloatMap$Entry <K> extends Internal.Map$Entry<K, number> {
        abstract getKey(): K;
        abstract setValue(arg0: number): number;
        /**
         * @deprecated
        */
        setValue(arg0: number): number;
        comparingByKey<K, V>(arg0: Internal.Comparator_<K>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        /**
         * @deprecated
        */
        getValue(): number;
        /**
         * @deprecated
        */
        setValue(arg0: any): any;
        comparingByValue<K, V extends Internal.Comparable<any>>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract hashCode(): number;
        copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        comparingByKey<K extends Internal.Comparable<any>, V>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        comparingByValue<K, V>(arg0: Internal.Comparator_<V>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract equals(arg0: any): boolean;
        abstract getFloatValue(): number;
        get key(): K
        set value(arg0: number)
        /**
         * @deprecated
        */
        set value(arg0: number)
        /**
         * @deprecated
        */
        get value(): number
        /**
         * @deprecated
        */
        set value(arg0: any)
        get floatValue(): number
    }
    type Object2FloatMap$Entry_<K> = Object2FloatMap$Entry<K>;
    class BlockDreadStairs extends Internal.StairBlock implements Internal.IDreadBlock, Internal.IDragonProof {
        constructor(baseBlockState: Internal.BlockState_, settings: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        static invokeGetStairShape(state: Internal.BlockState_, worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.StairsShape;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockDreadStairs_ = BlockDreadStairs;
    class InlineStyle$ISComponent <C> extends Internal.Record {
        constructor(id: string, codec: Internal.Codec_<C>, defaultValue: C)
        constructor(id: string, codec: Internal.Codec_<C>, defaultValue: C, merger: Internal.BiFunction_<C, C, C>)
        id(): string;
        defaultValue(): C;
        codec(): Internal.Codec<C>;
        merger(): Internal.BiFunction<C, C, C>;
        static ALL_COMPS: {"glowy": Internal.InlineStyle$ISComponent<any>, "glowyparent": Internal.InlineStyle$ISComponent<any>, "inlinedata": Internal.InlineStyle$ISComponent<any>, "hidden": Internal.InlineStyle$ISComponent<any>, "size": Internal.InlineStyle$ISComponent<any>};
    }
    type InlineStyle$ISComponent_<C> = InlineStyle$ISComponent<C>;
    interface RenderElement extends Internal.FadableScreenElement {
        abstract at<T extends Internal.RenderElement>(arg0: number, arg1: number, arg2: number): T;
        abstract getX(): number;
        abstract getZ(): number;
        abstract getWidth(): number;
        abstract withBounds<T extends Internal.RenderElement>(arg0: number, arg1: number): T;
        abstract getY(): number;
        render(graphics: Internal.GuiGraphics_, x: number, y: number): void;
        abstract render(arg0: Internal.GuiGraphics_): void;
        abstract withAlpha<T extends Internal.RenderElement>(arg0: number): T;
        abstract at<T extends Internal.RenderElement>(arg0: number, arg1: number): T;
        render(graphics: Internal.GuiGraphics_, x: number, y: number, alpha: number): void;
        abstract getHeight(): number;
        of(renderable: Internal.ScreenElement_): this;
        get x(): number
        get z(): number
        get width(): number
        get y(): number
        get height(): number
    }
    type RenderElement_ = RenderElement;
    class StringConfig extends Internal.ConfigFromString<string> {
        constructor()
        constructor(p: Internal.Pattern_)
        getColor(v: string): Internal.Color4I;
        getStringForGUI(v: string): net.minecraft.network.chat.Component;
        static readonly COLOR: Internal.Color4I;
        readonly pattern: Internal.Pattern;
    }
    type StringConfig_ = StringConfig;
    interface LevelChunkAccess {
        abstract csa$getStorage(): Internal.DataStorage;
        (): Internal.DataStorage_;
    }
    type LevelChunkAccess_ = LevelChunkAccess;
    class HolderSet$Direct <T> extends Internal.HolderSet$ListBacked<T> {
        unwrap(): Internal.Either<Internal.TagKey<T>, Internal.List<Internal.Holder<T>>>;
        static direct<E, T>($$0: Internal.Function_<E, Internal.Holder<T>>, ...$$1: E[]): Internal.HolderSet$Direct<T>;
        static direct<T>(...$$0: Internal.Holder_<T>[]): Internal.HolderSet$Direct<T>;
        forEach(arg0: Internal.Consumer_<Internal.Holder<T>>): void;
        static direct<T>($$0: Internal.List_<Internal.Holder<T>>): Internal.HolderSet$Direct<T>;
        unwrapKey(): Internal.Optional<Internal.TagKey<T>>;
        /**
         * @deprecated
        */
        static emptyNamed<T>($$0: Internal.HolderOwner_<T>, $$1: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        static direct<E, T>($$0: Internal.Function_<E, Internal.Holder<T>>, $$1: Internal.List_<E>): Internal.HolderSet$Direct<T>;
    }
    type HolderSet$Direct_<T> = HolderSet$Direct<T>;
    interface RecipeHolder {
        abstract getRecipeUsed(): Internal.Recipe<any>;
        setRecipeUsed($$0: Internal.Level_, $$1: Internal.ServerPlayer_, $$2: Internal.Recipe_<any>): boolean;
        abstract setRecipeUsed(arg0: Internal.Recipe_<any>): void;
        awardUsedRecipes($$0: Internal.Player_, $$1: Internal.List_<Internal.ItemStack>): void;
        get recipeUsed(): Internal.Recipe<any>
        set recipeUsed(arg0: Internal.Recipe_<any>)
    }
    type RecipeHolder_ = RecipeHolder;
    interface EnergyTransferable {
        abstract getEnergyStorage(arg0: Internal.Direction_): Internal.EnergyStorage;
        (arg0: Internal.Direction): Internal.EnergyStorage_;
    }
    type EnergyTransferable_ = EnergyTransferable;
    class AdvancementList {
        constructor()
        getAllAdvancements(): Internal.Collection<Internal.Advancement>;
        remove($$0: Internal.Set_<ResourceLocation>): void;
        setListener($$0: Internal.AdvancementList$Listener_): void;
        getRoots(): Internal.Iterable<Internal.Advancement>;
        clear(): void;
        add($$0: Internal.Map_<ResourceLocation, Internal.Advancement$Builder>): void;
        get($$0: ResourceLocation_): Internal.Advancement;
        get allAdvancements(): Internal.Collection<Internal.Advancement>
        set listener($$0: Internal.AdvancementList$Listener_)
        get roots(): Internal.Iterable<Internal.Advancement>
    }
    type AdvancementList_ = AdvancementList;
    abstract class Invokable <T, R> implements Internal.Member, Internal.AnnotatedElement {
        isFinal(): boolean;
        abstract isVarArgs(): boolean;
        getOwnerType(): Internal.TypeToken<T>;
        getModifiers(): number;
        getDeclaredAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getDeclaringClass(): T;
        getAnnotation<A extends Internal.Annotation>(arg0: A): A;
        abstract getAnnotatedReturnType(): Internal.AnnotatedType;
        abstract isOverridable(): boolean;
        returning<R1 extends R>(arg0: Internal.TypeToken_<R1>): Internal.Invokable<T, R1>;
        isPublic(): boolean;
        getName(): string;
        trySetAccessible(): boolean;
        isPrivate(): boolean;
        getParameters(): Internal.ImmutableList<Internal.Parameter>;
        isStatic(): boolean;
        getDeclaredAnnotations(): Internal.Annotation[];
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        static from(arg0: Internal.Method_): Internal.Invokable<any, any>;
        setAccessible(arg0: boolean): void;
        getAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        isPackagePrivate(): boolean;
        getDeclaredAnnotation<T extends Internal.Annotation>(arg0: T): T;
        accessFlags(): Internal.Set<Internal.AccessFlag>;
        isAbstract(): boolean;
        isNative(): boolean;
        isSynthetic(): boolean;
        static from<T>(arg0: Internal.Constructor_<T>): Internal.Invokable<T, T>;
        isSynchronized(): boolean;
        getExceptionTypes(): Internal.ImmutableList<Internal.TypeToken<Internal.Throwable>>;
        invoke(arg0: T, ...arg1: any[]): R;
        getReturnType(): Internal.TypeToken<R>;
        isProtected(): boolean;
        getAnnotations(): Internal.Annotation[];
        abstract getTypeParameters(): any[];
        returning<R1 extends R>(arg0: R1): Internal.Invokable<T, R1>;
        isAccessible(): boolean;
        get "final"(): boolean
        get varArgs(): boolean
        get ownerType(): Internal.TypeToken<T>
        get modifiers(): number
        get declaringClass(): T
        get annotatedReturnType(): Internal.AnnotatedType
        get overridable(): boolean
        get "public"(): boolean
        get name(): string
        get "private"(): boolean
        get parameters(): Internal.ImmutableList<Internal.Parameter>
        get "static"(): boolean
        get declaredAnnotations(): Internal.Annotation[]
        set accessible(arg0: boolean)
        get packagePrivate(): boolean
        get "abstract"(): boolean
        get "native"(): boolean
        get synthetic(): boolean
        get "synchronized"(): boolean
        get exceptionTypes(): Internal.ImmutableList<Internal.TypeToken<Internal.Throwable>>
        get returnType(): Internal.TypeToken<R>
        get "protected"(): boolean
        get annotations(): Internal.Annotation[]
        get typeParameters(): any[]
        get accessible(): boolean
    }
    type Invokable_<T, R> = Invokable<T, R>;
}
